import json

"""
This script performs the following actions:

1. Data Loading: Opens a file named 'icons.json' located in the '/metadata' folder 
   and reads its content, converting it into JSON format for processing.

2. Data Processing: Iterates over each element in the loaded JSON file. For each element:
   - Prints the name and associated Unicode code to the console.
   - Filters out entries with Unicode codes that have fewer than 4 characters.
   - Creates a new dictionary 'writeData' with selected fields from the original element: 
     'Name', 'Label', 'Styles', 'Search', and 'Unicode'.
   - Converts the Unicode code of each element to the appropriate format.

3. Generating a New JSON File: All processed elements are added to a 'new_data' list. 
   This list is then converted to JSON format and written to a new file 
   named 'UE_FontAwsome_DataTable.json'. This file is formatted to facilitate import 
   into Unreal Engine (UE).

This script helps to simplify and convert the content of the original 'icons.json' file 
for use in a data table within UE.
"""


# 1- Path of the icons.json file that can be found in the /metadata folder when the fonts are downloaded
load_file_path = './icons.json'
# 2 - The path and filename for the file that will be generated by simplifying and converting the data for import into UE
new_file_path = './UE_FontAwsome_DataTable.json'


## Opens the icons.json file to read the data and then converts it into JSON format for parsing
file = open(load_file_path ,"r");
dataJson = json.loads(file.read())

## START PROCESS
with open(new_file_path ,'w') as file:

    ## New data converted
    new_data = []

    index=0
    for i in dataJson:

        ## Print Names into console
        print (i)
        print ("---",dataJson[i]['unicode'])

        
        if len(dataJson[i]['unicode']) < 4:
            continue

        ## (OPTIONAL) USE HERE CONDITION IF WANT FILTER 
        ####### HERE #########
        
        
        ## Parsing Data to DataTable Format
        writeData={}
        
        ## Name field it's important when what to use Datatable
        ## DO NOT REMOVE THIS FIELD
        writeData.update({'Name': i })


        ## These are the values that will be obtained from the original file to be added to the new file, providing others
        writeData.update({'Label': dataJson[i]['label'] })
        writeData.update({'Styles': dataJson[i]['styles'] })
        writeData.update({'Search': dataJson[i]['search']['terms'] })
        writeData.update({'Unicode': eval('"'+'\\u'+dataJson[i]['unicode']+'"')})

        ## Append new value converted into the new array data 
        new_data.append(writeData)
    

    ## Create a Json and write into a new file
    json.dump(new_data, file, indent = 4)
    file.close()

    ## END PROCESS
