// Copyright Epic Games, Inc. All Rights Reserved.

using UnrealBuildTool;

public class IdealTwinPro : ModuleRules
{
	public IdealTwinPro(ReadOnlyTargetRules Target) : base(Target)
	{
		PCHUsage = ModuleRules.PCHUsageMode.UseExplicitOrSharedPCHs;


		PublicDependencyModuleNames.AddRange(new string[]
		{
			"IdealTwinSDK",
			"VariantManagerContent",
			"GameplayTags",
			
		});
		PrivateDependencyModuleNames.AddRange(
			new string[] {
				
				
				"HTTP",
				"Core",
				"CoreUObject",
				"Engine",

				"Slate",
				"SlateCore",
				"UMG",
				"MediaAssets",

				"InputCore",
				"EnhancedInput",
				"AIModule",
				"NavigationSystem",

				"DeveloperSettings", 
			});
		if (Target.Type == TargetType.Editor)
		{
			PrivateDependencyModuleNames.AddRange(new string[]
			{
				"UnrealEd",
				"InputEditor",
				"Blutility",
				"UMGEditor",
				"EditorScriptingUtilities", 
			});
		}
	}
}