﻿// Fill out your copyright notice in the Description page of Project Settings.

#pragma once

#include "CoreMinimal.h"
#include "UObject/Object.h"
#include "IdealTwinExperimental.generated.h"


class UFileMediaSource;

USTRUCT(BlueprintType)
struct IDEALTWINPRO_API FVideoResourceReader
{
	GENERATED_BODY()

	UPROPERTY(EditAnywhere,BlueprintReadWrite, Category="VideoResourceReader")
	FString VideoName;
	UPROPERTY(EditAnywhere,BlueprintReadWrite, Category="VideoResourceReader")
	UFileMediaSource* SourceVideo;
	UPROPERTY(EditAnywhere,BlueprintReadWrite, Category="VideoResourceReader")
	UTexture* Thumbnail;
	
	FVideoResourceReader(): SourceVideo(nullptr), Thumbnail(nullptr)
	{}

	FVideoResourceReader(const FString& InName, UFileMediaSource* InSource, UTexture* InThumbnail = nullptr): VideoName(InName), SourceVideo(InSource),
	                                                                         Thumbnail(InThumbnail)
	{}
};

/** Experimental features to test new implementations or have internal features for different projects */
UCLASS()
class IDEALTWINPRO_API UIdealTwinExperimental : public UBlueprintFunctionLibrary
{
	GENERATED_BODY()

public:
	UFUNCTION(BlueprintCallable, Category="IdealTwinExperimental|VideoReader", meta=(CallableWithoutWorldContext))
	static TArray<FVideoResourceReader> GetListVideoResourcesOnMoviesFolder(); 
};
