﻿// Fill out your copyright notice in the Description page of Project Settings.

#pragma once

#include "CoreMinimal.h"
#include "GameplayTagContainer.h"
#include "Components/ActorComponent.h"
#include "StructUtils/InstancedStruct.h"

#include "MinimapElementComponent.generated.h"


struct FMinimapIconSettings;
class UMinimapWidget;
class UMinimapConfigAsset;


USTRUCT(BlueprintType)
struct FMinimapElementData
{
	GENERATED_BODY()
	UPROPERTY(EditAnywhere, BlueprintReadWrite, Category="MinimapElementData")
	FText Title;
	UPROPERTY(EditAnywhere, BlueprintReadWrite, Category="MinimapElementData")
	FText Description;
};








DECLARE_DYNAMIC_MULTICAST_DELEGATE_OneParam(FOnDynamicChanged, UMinimapElementComponent*, Component);
DECLARE_DYNAMIC_MULTICAST_DELEGATE(FOnIconElementInteract);

UCLASS(ClassGroup=(IdealTwin), meta=(BlueprintSpawnableComponent))
class IDEALTWINPRO_API UMinimapElementComponent : public UActorComponent
{
	GENERATED_BODY()

public:
	UMinimapElementComponent();

	/*Event that notifies minimap widget that the icon dynamic parameter has changed*/
	UPROPERTY(BlueprintAssignable)
	FOnDynamicChanged OnDynamicChanged;
	UPROPERTY(BlueprintAssignable)
	FOnIconElementInteract OnIconElementInteract;
	
	
	/*Used to define the type of minimap icon and find its style in the Minimap Data Asset*/
	UPROPERTY(EditAnywhere, BlueprintReadOnly, Category="MinimapElement")
	FGameplayTag MinimapIconType;

	/*Allows to override the base dynamic mode of the component*/
	UPROPERTY(EditAnywhere, BlueprintReadWrite, Category="MinimapElement", meta=(InlineEditConditionToggle))
	bool bOverrideDynamic;
	
	/*Overrides the dynamic mode*/
	UPROPERTY(EditAnywhere, BlueprintReadWrite, Category="MinimapElement", meta=(EditCondition="bOverrideDynamic"))
	bool bDynamicMinimapIcon;

	/* If it's true the minimap icon will take the actor look (X axis) direction on display*/
	UPROPERTY(EditAnywhere, BlueprintReadWrite, Category="MinimapElement", meta=(EditCondition="!bDynamicMinimapIcon",EditConditionHides))
	bool bUseActorLookDirection;


	UPROPERTY(EditAnywhere, BlueprintReadWrite, Category="MinimapElement", meta = (BaseStruct="/Script/IdealTwinPro.MinimapElementData"))
	FInstancedStruct IconElementData;
	
	
	
	/*Overrides the dynamic mode with the provided one*/
	UFUNCTION(BlueprintCallable, Category="MinimapElement")
	void SetDynamicIcon(bool bDynamic);


	bool CanUseRotation()const;

	virtual void InitializeComponent() override;

	void InitializeMinimapElement();
	void SetMinimapWidgetTarget(UMinimapWidget* InMinimapWidgetTarget);

	FMinimapIconSettings GetMinimapIcon() const;

protected:
	// Called when the game starts
	virtual void BeginPlay() override;

private:
	UPROPERTY() TObjectPtr<UMinimapWidget> MinimapWidgetTarget;
};


