﻿// Fill out your copyright notice in the Description page of Project Settings.

#pragma once

#include "CoreMinimal.h"
#include "UObject/Interface.h"

#include "MinimapIconInterface.generated.h"

class UMinimapElementComponent;

UINTERFACE()
class UMinimapIconInterface : public UInterface
{
	GENERATED_BODY()
};

/**
 * 
 */
class IDEALTWINPRO_API IMinimapIconInterface
{
	GENERATED_BODY()
	
public:
	/**
	 * Implement this interface in the class that will be used as a Minimap Icon
	 * @param W_Minimap - Minimap widget in which the icon will be added 
	 * @param IconElement - Gameplay tag that define the type of the minimap icon
	 */
	UFUNCTION(BlueprintNativeEvent, BlueprintCallable, Category="MinimapInterface")
	void SetUpMinimapIconComponents(UUserWidget* W_Minimap, UMinimapElementComponent* IconElement);
};
