﻿// Fill out your copyright notice in the Description page of Project Settings.

#pragma once

#include "CoreMinimal.h"
#include "MinimapConfigAsset.h"
#include "Blueprint/UserWidget.h"

#include "MinimapIconInterface.h"

#include "MinimapIconWidget.generated.h"

/**
 * 
 */
UCLASS(Abstract)
class IDEALTWINPRO_API UMinimapIconWidget : public UUserWidget, public IMinimapIconInterface
{
	GENERATED_BODY()

public:
	
	/*Icon image*/
	UPROPERTY(BlueprintReadOnly, meta=(BindWidget,OptionalWidget = true), Category = "Minimap Icon")
	TObjectPtr<class UImage> IconImage;

	/*Minimap Icon Size*/
	UPROPERTY(EditAnywhere, Category = "Minimap Icon")
	FVector2D MinimapIconSize;

	/** Triggers the interaction event for the associated minimap element.
	 * Broadcasts the `OnIconElementInteract` delegate from the `MinimapElement`.*/
	UFUNCTION(BlueprintCallable, Category = "Minimap Icon")
	void InteractionElement();

	/** Handles the construction logic for the icon in the minimap widget.
	 * Intended to be overridden in Blueprints for custom behavior.*/
	UFUNCTION(BlueprintNativeEvent, Category = "Minimap Icon")
	void OnIconConstruct(FMinimapIconSettings IconSettings, UMinimapElementComponent* IconElement);
	virtual void OnIconConstruct_Implementation(FMinimapIconSettings IconSettings, UMinimapElementComponent* IconElement);

	
	/** Used to apply the icon style obtained from the MinimapDataAsset */
	virtual void SetUpMinimapIconComponents_Implementation(UUserWidget* W_Minimap, UMinimapElementComponent* IconElement) override;

#if WITH_EDITOR
	virtual void PostEditChangeProperty(FPropertyChangedEvent& PropertyChangedEvent) override;
#endif

protected:
	UPROPERTY()
	TObjectPtr<UUserWidget> MinimapWidget;
	UPROPERTY(VisibleAnywhere,BlueprintReadOnly)
	FMinimapIconSettings MinimapIconSettings;
	UPROPERTY(VisibleAnywhere,BlueprintReadOnly)
	TObjectPtr<UMinimapElementComponent> MinimapElement;
};
