#pragma once

#include "CoreMinimal.h"
#include "Kismet/BlueprintAsyncActionBase.h"
#include "AsyncTeleportWithFade.generated.h"


DECLARE_DYNAMIC_MULTICAST_DELEGATE(FSimpleTPDelegate);
 
UCLASS()
class IDEALTWINPRO_API UAsyncTeleportWithFade : public UBlueprintAsyncActionBase
{
	GENERATED_BODY()

public:
	UFUNCTION(BlueprintCallable, meta = (BlueprintInternalUseOnly = "true", WorldContext = "WorldContextObject"), Category = "Teleport")
	static UAsyncTeleportWithFade* TeleportWithFade(UObject* WorldContextObject, AActor* TargetActor, FVector TargetLocation, FRotator TargetRotation, float FadeInTime = .2f, float DelayAfterTeleport = .5f, float
	                                                FadeOutTime = .2f, FLinearColor FadeColor = FLinearColor::White);

	UPROPERTY(BlueprintAssignable)
	FSimpleTPDelegate OnPreTeleported;
	UPROPERTY(BlueprintAssignable)
	FSimpleTPDelegate OnTeleported;
	UPROPERTY(BlueprintAssignable)
	FSimpleTPDelegate OnCompleted;

	virtual void Activate() override;


private:
	UPROPERTY()
	UObject* WorldContextObject;

	UPROPERTY()
	AActor* TargetActor;

	FVector TargetLocation;
	FRotator TargetRotation;
	float FadeTime;
	float DelayAfterTeleport;
	FLinearColor FadeColor;

	void StartFade();
	void DoTeleport();
	void EndFade() const;

	FTimerHandle DelayHandle1;
	FTimerHandle DelayHandle2;
};
