// Fill out your copyright notice in the Description page of Project Settings.

#pragma once

#include "CoreMinimal.h"
#include "GameplayTagContainer.h"
#include "UObject/Object.h"
#include "ITwISPPayLoad.generated.h"


/**
 * 
 */
UCLASS(Blueprintable, BlueprintType,EditInlineNew,DisplayName="ISP PayLoad")
class IDEALTWINPRO_API UITwISPPayLoad : public UObject
{
	GENERATED_BODY()

public:
	UITwISPPayLoad(const FObjectInitializer& ObjectInitializer);
	
	UPROPERTY(EditAnywhere,BlueprintReadOnly,Category="ISPPayload")
	FGameplayTag PayloadGroup;
	UPROPERTY(EditAnywhere,BlueprintReadWrite,Category="ISPPayload")
	FGameplayTag PayloadID;

	
	UPROPERTY(EditAnywhere,BlueprintReadWrite,Category="ISPPayload")
	FText DisplayName;
	UPROPERTY(EditAnywhere,BlueprintReadWrite,Category="ISPPayload")
	FText Description;

	/** Class path reference for a 3D UI widget used in visual representation using IdealTwinISPWidget*/
	UPROPERTY(EditAnywhere, BlueprintReadWrite,Category="ISPPayload",meta=(AllowedClasses="/Script/IdealTwinProUI.ITwISPWidget"))
	FSoftClassPath Widget3DClass;
};


UCLASS()
class UISPAmenities : public UITwISPPayLoad 
{
	GENERATED_BODY()

public:
	UISPAmenities(const FObjectInitializer& ObjectInitializer);


};

UCLASS()
class UISPNearby : public UITwISPPayLoad
{
	GENERATED_BODY()

public:
	UISPNearby(const FObjectInitializer& ObjectInitializer);
};

UCLASS(meta=(DisplayName="ISP Point of Interest"))
class UISPPOI : public UITwISPPayLoad
{
	GENERATED_BODY()

public:
	UISPPOI(const FObjectInitializer& ObjectInitializer);
};