// Fill out your copyright notice in the Description page of Project Settings.

#pragma once

#include "CoreMinimal.h"
#include "UObject/Object.h"
#include "ITwISPActionsBase.generated.h"

class AITwInteractiveSpot;

/** UITwISPActionsBase is an abstract base class used to handle interaction with ITwISPInteractSpot and customized some post actions */
UCLASS(Blueprintable,BlueprintType,EditInlineNew)
class IDEALTWINPRO_API UITwISPActionsBase : public UObject
{
	GENERATED_BODY()

public:

	UFUNCTION(BlueprintCallable,BlueprintNativeEvent,Category="InteractSpotPlacementActions")
	void OnPawnEnter(AITwInteractiveSpot* Spot, APawn* InPawn);
	UFUNCTION(BlueprintCallable,BlueprintNativeEvent,Category="InteractSpotPlacementActions")
	void OnPawnExit(AITwInteractiveSpot* Spot, APawn* InPawn);

	UFUNCTION(BlueprintCallable,BlueprintNativeEvent,Category="InteractSpotPlacementActions")
	void OnChangeVisibility(AITwInteractiveSpot* Spot, bool bVisible);
	UFUNCTION(BlueprintCallable,BlueprintNativeEvent,Category="InteractSpotPlacementActions")
	void OnChangeVisibilityTitle(AITwInteractiveSpot* Spot, bool bVisible);
	UFUNCTION(BlueprintCallable,BlueprintNativeEvent,Category="InteractSpotPlacementActions")
	void OnChangeVisibilityVolume(AITwInteractiveSpot* Spot, bool bVisible);

	UFUNCTION(BlueprintCallable,BlueprintNativeEvent,Category="InteractSpotPlacementActions")
	void OnSelection(AITwInteractiveSpot* Spot,bool bSelected);
};
