// Fill out your copyright notice in the Description page of Project Settings.

#pragma once

#include "CoreMinimal.h"
#include "IdealTwinAPI/Configurator/IdealTwinConfiguratorModels.h"
#include "IdealTwinCommon/ProjectRequestsManager/IdealTwinProjectRequestManager.h"
#include "UObject/Object.h"
#include "IdealTwinConfiguratorDataAsset.generated.h"


// TODO Doc this page

USTRUCT(BlueprintType) struct FIdealTwinItemOverrideImage
{
	GENERATED_BODY()
	UPROPERTY(EditAnywhere,BlueprintReadWrite,Category="IdealTwinItemOverrideData", meta=(AllowedClasses="/Script/Engine.Texture, /Script/Engine.Material, /Script/Engine.MaterialInstances"))
	FSoftObjectPath ImageDisplay;

	// TODO future compatibility with font icons
	/*UPROPERTY(EditAnywhere,BlueprintReadWrite,Category="IdealTwinItemOverrideData|FontIcon")
	FFontIconHandler IconDisplay;*/
};
USTRUCT(BlueprintType) struct FIdealTwinItemOverrideData
{
	GENERATED_BODY()
	UPROPERTY(VisibleInstanceOnly,BlueprintReadWrite,Category="IdealTwinItemOverrideData")
	FName ItemID;
	UPROPERTY(EditAnywhere,BlueprintReadWrite,Category="IdealTwinItemOverrideData")
	FText DisplayText;
	UPROPERTY(EditAnywhere,BlueprintReadWrite,Category="IdealTwinItemOverrideData")
	FIdealTwinItemOverrideImage DisplayImage;
};

/* Informacion para sobrescribir la inforamcion del ConfiguratorDataAsset y poder cambiar el texto display o el icono para mostrar*/
UCLASS(Blueprintable,BlueprintType) class IDEALTWINPRO_API UIdealTwinConfiguratorItemOverride : public UDataAsset
{
	GENERATED_BODY()
public:

	UPROPERTY(EditAnywhere,BlueprintReadWrite,Category="ConfiguratorItemOverride")
	TMap<FName,FIdealTwinItemOverrideData> ItemOverrideList;

	UPROPERTY(EditAnywhere,BlueprintReadWrite,Category="ConfiguratorItemOverride|Placeholder", meta=(AllowedClasses="/Script/Engine.Texture, /Script/Engine.Material, /Script/Engine.MaterialInstances"))
	FIdealTwinItemOverrideImage CategoryPlaceholder;
	UPROPERTY(EditAnywhere,BlueprintReadWrite,Category="ConfiguratorItemOverride|Placeholder", meta=(AllowedClasses="/Script/Engine.Texture, /Script/Engine.Material, /Script/Engine.MaterialInstances"))
	FIdealTwinItemOverrideImage SubCategoryPlaceholder;
	UPROPERTY(EditAnywhere,BlueprintReadWrite,Category="ConfiguratorItemOverride|Placeholder", meta=(AllowedClasses="/Script/Engine.Texture, /Script/Engine.Material, /Script/Engine.MaterialInstances"))
	FIdealTwinItemOverrideImage ProductPlaceholder;
};


DECLARE_DYNAMIC_MULTICAST_DELEGATE(FOnConfiguratorAssetUpdated);
/* Informacion de un configurador dentro de IdealTwin para poder para ser linkeado con el level variant actor y poder pasar configuraciones a web*/
UCLASS(Blueprintable,BlueprintType) class IDEALTWINPRO_API UIdealTwinConfiguratorDataAsset : public UDataAsset
{
	GENERATED_BODY()
public:
	UIdealTwinConfiguratorDataAsset(const FObjectInitializer& ObjectInitializer);
	
	UPROPERTY(BlueprintAssignable)
	FOnConfiguratorAssetUpdated OnConfiguratorAssetUpdated;
	
	
	UPROPERTY(EditAnywhere,BlueprintReadWrite,Category="ConfiguratorDataAsset")
	FName ConfiguratorName;
	UPROPERTY(EditAnywhere,BlueprintReadWrite,Category="ConfiguratorDataAsset")
	TArray<FIdealTwinConfigRoom> Room;
	UPROPERTY(EditAnywhere, BlueprintReadOnly, Category="ConfiguratorDataAsset", meta=(AllowedClasses="/Script/VariantManagerContent.LevelVariantSets"))
	FSoftObjectPath LevelVariantSets;


	UFUNCTION(BlueprintCallable, Category = "ConfiguratorDataAsset|ConfiguratorChangesList")
	void LoadConfiguratorData();

	void LoadConfiguratorDataOffline();
	
	UFUNCTION(BlueprintCallable, Category = "ConfiguratorDataAsset|ConfiguratorChangesList")
	void RequestConfiguratorSelection();	
	UFUNCTION(BlueprintCallable, Category = "ConfiguratorDataAsset|ConfiguratorChangesList")
	void LoadConfiguratorSelection();
	
	UFUNCTION(BlueprintCallable, Category = "ConfiguratorDataAsset|ConfiguratorChangesList")
	void SendConfiguratorList();
	UFUNCTION(BlueprintPure, Category = "ConfiguratorDataAsset|ConfiguratorChangesList")
	bool IsConfiguratorKey(const FString& ProductId) const;


	UFUNCTION(BlueprintCallable, Category = "ConfiguratorDataAsset|ConfiguratorChangesList")
	bool GetConfiguratorProductByKey(const FName& ProductName, FIdealTwinConfigProduct& OutProduct) const;
	
	UFUNCTION(BlueprintCallable, Category = "ConfiguratorDataAsset|ConfiguratorChangesList")
	bool AddItemChangeList(const FName& InCatID, const FName& InSubCatID, const FName& ProductName);
	UFUNCTION(BlueprintCallable, Category = "ConfiguratorDataAsset|ConfiguratorChangesList")
	bool RemoveConfigurationChange(const FIdealTwinConfigProduct& ConfigProduct);

	UFUNCTION(BlueprintCallable, Category = "ConfiguratorDataAsset|ConfiguratorChangesList")
	TMap<FName,FIdealTwinConfigProduct> GetChangesList()const;

	UFUNCTION(BlueprintCallable, Category = "ConfiguratorDataAsset|ConfiguratorChangesList")
	bool IsProductInList(const FName& InProductId)const;
	UFUNCTION(BlueprintCallable, Category = "ConfiguratorDataAsset|ConfiguratorChangesList")
	bool IsProductSelected(const FName& InProductId)const;
	
	void ApplyChangeListSelectionToVariant();
	
	void StopConfiguratorBackGroundProcess();

	/**
	 * Checks if the configurator has been loaded.
	 *
	 * @return True if the configurator is loaded, false otherwise.
	 */
	bool IsLoadedConfigurator()const { return bLoadedConfiguration;}

	void SetWorldTarget(UWorld* InWorld);
protected:
	UPROPERTY() TObjectPtr<UWorld> WorldTarget;

	UFUNCTION() void Received_ConfigurationSaved(UIdealTwinErrorHandler* Error);
	UFUNCTION() void Received_ConfigurationSelection(UIdealTwinConfiguratorHandler* ResultData, UIdealTwinErrorHandler* Error);
	UFUNCTION() void Received_ConfiguratorData(EUpdateRequestDataType DataType, EUpdateRequestType RequestType);

	UPROPERTY() TMap<FName,FIdealTwinConfigProduct> ConfigtorChangesList;

	// Generated a list with all selected products in the change list 
	TArray<int32> GetSelectedProductIdFromChangeList()const;
	// Find the configurator unit in the wrapper by the asset configurator name
	bool FindConfiguratorUnitInWrappers(FIdealTwinConfigUnit& OutConfigUnit) const;

	TArray<int32> CurrentProductSelectionList;
	TArray<int32> LastProductSelectionList;

	// If the configurator was loaded from web it will be true
	bool bLoadedConfiguration;
	
	bool bBlockUpdateForUpdateData;
	bool bIsBackGroundProcessing;

	FTimerHandle TimerHandle;
};
