﻿// Fill out your copyright notice in the Description page of Project Settings.

#pragma once

#include "CoreMinimal.h"
#include "IdealTwinConfiguratorDataAsset.h"
#include "LevelVariantSetsActor.h"
#include "Engine/DataTable.h"
#include "IdealTwinLevelVariantSetsActor.generated.h"

class UIdealTwinVariantHandler;

UCLASS(hideCategories=(Rendering, Physics, LOD, Activation, Input, Actor, Cooking))
class IDEALTWINPRO_API AIdealTwinLevelVariantSetsActor : public ALevelVariantSetsActor
{
	GENERATED_BODY()

public:
	AIdealTwinLevelVariantSetsActor(const FObjectInitializer& ObjectInitializer);
	
	UPROPERTY(EditAnywhere, BlueprintReadOnly, Category="IdealTwinLevelVariantSets")
	TObjectPtr<UIdealTwinConfiguratorDataAsset> ConfiguratorData;
	
	UPROPERTY(EditAnywhere, BlueprintReadOnly, Category="IdealTwinLevelVariantSets", meta=(AllowedClasses="/Script/IdealTwinPro.IdealTwinConfiguratorItemOverride"))
	FSoftObjectPath ItemOverride;
	
	UFUNCTION(BlueprintCallable,Category="IdealTwinLevelVariantSets", meta=(WorldContext="WorldContext"))
	static AIdealTwinLevelVariantSetsActor* GetItwLevelVariantSetsActor(const UObject* WorldContext, bool& bValid);
	UFUNCTION(BlueprintCallable,Category="IdealTwinLevelVariantSets")
	UIdealTwinVariantHandler* GetVariantWrapper()const { return VariantWrapper; }


	UFUNCTION(CallInEditor,Category="IdealTwinLevelVariantSets")
	void CreateSwitchPawnViewVariantSet();

	UFUNCTION(BlueprintCallable,Category="IdealTwinLevelVariantSets")
	void SwitchOnViewPawnVariant(bool bOrbital);
	
	
protected:
	virtual void BeginPlay() override;
	virtual void BeginDestroy() override;
	

	#if WITH_EDITOR
	virtual void PostInitProperties() override;
	virtual void PostLoad() override;
	virtual void PostEditChangeProperty(FPropertyChangedEvent& PropertyChangedEvent) override;
	#endif

	void LoadAssetsForConfigurator();

	
	
private:
	UPROPERTY() UIdealTwinVariantHandler* VariantWrapper;
};
