// Fill out your copyright notice in the Description page of Project Settings.

#pragma once

#include "CoreMinimal.h"
#include "IdealTwinAPI/RealEstateAPI/Models/IdealTwinRealEstateDataModels.h"
#include "UObject/Object.h"
#include "UnitVolumeAction.generated.h"

class AUnitVolumeActor;
/**
 * 
 */
UCLASS(Blueprintable,Abstract,EditInlineNew)
class IDEALTWINPRO_API UUnitVolumeAction : public UObject
{
	GENERATED_BODY()
public:
	UFUNCTION(BlueprintCallable,BlueprintNativeEvent,Category="UnitVolumeAction")
	void OnUnitVolumeVisibilityChanged(AUnitVolumeActor* UnitVolume, bool bIsVisible);
	UFUNCTION(BlueprintCallable,BlueprintNativeEvent,Category="UnitVolumeAction")
	void OnUnitVolumeSelection(AUnitVolumeActor* UnitVolume, bool bIsSelected);
	UFUNCTION(BlueprintCallable,BlueprintNativeEvent,Category="UnitVolumeAction")
	void OnUnitVolumeUpdateData(AUnitVolumeActor* UnitVolume, const FUnitData& NewData);
};
