// Fill out your copyright notice in the Description page of Project Settings.

#pragma once

#include "CoreMinimal.h"
#include "UnitVolumeConfig.generated.h"


/** UUnitVolumeConfig is a configuration asset for UnitVolumeScene to have a color scheme and display parameters.*/
UCLASS()
class IDEALTWINPRO_API UUnitVolumeConfig : public UDataAsset
{
	GENERATED_BODY()
public:
	UUnitVolumeConfig(const FObjectInitializer&ObjectInitializer);
	
	/* Material to be used in the UnitVolume.*/
	UPROPERTY(EditAnywhere,BlueprintReadWrite, Category="MaterialInstance")
	UMaterialInterface* UnitVolumeMaterial;
	UPROPERTY(EditAnywhere,BlueprintReadWrite, Category="MaterialInstance")
	UMaterialInterface* UnitVolumeMaterialFrame;
	
	UPROPERTY(EditAnywhere,BlueprintReadWrite, Category="ColorInstance")
	FLinearColor AvailableColor;
	UPROPERTY(EditAnywhere,BlueprintReadWrite, Category="ColorInstance")
	FLinearColor ReserveColor;
	UPROPERTY(EditAnywhere,BlueprintReadWrite, Category="ColorInstance")
	FLinearColor SoldColor;
	UPROPERTY(EditAnywhere,BlueprintReadWrite, Category="ColorInstance")
	FLinearColor UnvalidColor;

	UPROPERTY(EditAnywhere,BlueprintReadWrite, Category="ColorInstance")
	FLinearColor FrameColor;


	
	/* Flickering time speed*/
	UPROPERTY(EditAnywhere,BlueprintReadWrite, Category="ColorParameters")
	float TimeSpeed = 2.f;
	/* Max emissive color by default*/
	UPROPERTY(EditAnywhere,BlueprintReadWrite, Category="ColorParameters")
	float EmissivePower = 1;
	/* Normal opacity*/
	UPROPERTY(EditAnywhere,BlueprintReadWrite, Category="ColorParameters")
	float Opacity = 0.4f;

};