// Fill out your copyright notice in the Description page of Project Settings.

#pragma once

#include "CoreMinimal.h"
#include "Components/ActorComponent.h"
#include "IdealTwinAutoRotationComponent.generated.h"

class  USpringArmComponent;

UENUM(BlueprintType)
enum EAutoRotationDirection
{
	EAD_Right UMETA(DisplayName = "Right"),
	EAD_Left UMETA(DisplayName = "Left"),
};
UENUM(BlueprintType)
enum EAutoRotationActivationMethod
{
	EAAM_Manual UMETA(DisplayName = "By Code"),
	EAAM_Input UMETA(DisplayName = "IdealTwin Input Subsystem"),
};


USTRUCT(Blueprintable, BlueprintType)
struct FAutoRotationSettings
{
	GENERATED_BODY()

	FAutoRotationSettings();

	UPROPERTY(EditAnywhere, Category = "AutoOrbitSettings")
	float UpdateRate;
	UPROPERTY(BlueprintReadWrite, EditAnywhere, Category = "AutoOrbitSettings")
	TEnumAsByte<EAutoRotationDirection> AutoRotationDirection;
	UPROPERTY(BlueprintReadWrite, EditAnywhere, Category = "AutoOrbitSettings")
	TEnumAsByte<EAutoRotationActivationMethod> AutoRotationActivationMethod;
	
	//How fast the is going to rotate (degrees per second)
	UPROPERTY(EditAnywhere, Category = "AutoOrbitSettings")
	float DeltaRotationYaw;
};


DECLARE_DYNAMIC_MULTICAST_DELEGATE_OneParam(FOnAutoRotationStart, bool, bStart);

UCLASS(ClassGroup=(IdealTwin), meta=(BlueprintSpawnableComponent))
class IDEALTWINPRO_API UIdealTwinAutoRotationComponent : public UActorComponent
{
	GENERATED_BODY()

public:
	UIdealTwinAutoRotationComponent();
	
	UPROPERTY(BlueprintAssignable, Category="IdealTwinAutoRotationComponent")
	FOnAutoRotationStart OnAutoRotationStart;
	
	UPROPERTY(EditAnywhere, BlueprintReadWrite, Category="IdealTwinAutoRotationComponent")
	FAutoRotationSettings AutoRotationSettings;

	UFUNCTION(BlueprintCallable, Category="IdealTwinAutoRotationComponent")
	void SetAutoRotationDirection(TEnumAsByte<EAutoRotationDirection> Direction);
	
	
	UFUNCTION(BlueprintCallable, Category="IdealTwinAutoRotationComponent")
	void StartAutoRotation();
	UFUNCTION(BlueprintCallable, Category="IdealTwinAutoRotationComponent")
	void StopAutoRotation();
	
	
	

protected:
	virtual void BeginPlay() override;

	UFUNCTION() void UpdateAutoRotation();

	UFUNCTION() void OnInputInactive(bool bUserActive);

	FTimerHandle UpdateTimerHandle;	
	
	UPROPERTY() TObjectPtr<ACharacter> OwnCharacter;
	UPROPERTY() TObjectPtr<AController> OwnController;
	UPROPERTY() TObjectPtr<USpringArmComponent> SpringArmObject;

};
