// Fill out your copyright notice in the Description page of Project Settings.

#pragma once

#include "CoreMinimal.h"
#include "IdealTwinBaseCharacter.h"
#include "IdealTwinOrbitalCharacter.generated.h"

/*	Character prepared to be use in exteriors or orbital-view behaviour. This character implements IPawnSwitchInterface
	Implements:
		- NonGravityMovement, move orbital pawn without fall because of gravity.
		- Special view clamp
 */
UCLASS()
class IDEALTWINPRO_API AIdealTwinOrbitalCharacter : public AIdealTwinBaseCharacter
{
	GENERATED_BODY()

public:
	AIdealTwinOrbitalCharacter(const FObjectInitializer& ObjectInitializer);


protected:
	virtual void BeginPlay() override;
	virtual void Tick(float DeltaTime) override;
	virtual void Destroyed() override;
	virtual void PostLoad() override;

	/*	Movement implementation switches between NoGravityMovement method or normal Gravity movement. It is determined by bUsePawnGravity.
		When non-gravity is enabled, MovementMultiplier is what apply the velocity.
	 */
	virtual void MoveCharacter_Implementation(FVector2D MoveValue) override;

	/* Method to apply movement without using gravity. This method is called in MoveCharacter_Implementation*/
	void NoGravityMovement(const FVector2D& Val);

#if WITH_EDITOR
	virtual void PostEditChangeProperty(FPropertyChangedEvent& PropertyChangedEvent) override;
#endif

public:
	virtual void StoreInitialClamp();
	virtual void FixClampedLocation();

	
	UPROPERTY(EditAnywhere, BlueprintReadOnly, Category="IdealTwinCharacter|Pan Movement")
	bool bUsePanMovement;
	/*If is false disable pawn gravity and change pawn movement logic. Recommend when orbital pawn are not touching ground collision*/
	UPROPERTY(EditAnywhere, BlueprintReadOnly, Category="IdealTwinCharacter|Pan Movement")
	bool bUsePawnGravity = false;
	/*This value is applied in pawn movement when UseGravity is false.*/
	UPROPERTY(EditAnywhere, BlueprintReadOnly, Category="IdealTwinCharacter|Pan Movement",
		meta=(EditCondition="bUsePawnGravity"))
	float MovementMultiplier;
	UPROPERTY(EditAnywhere, BlueprintReadOnly, Category="IdealTwinCharacter|Pan Movement",
		meta = (EditCondition="bUsePanMovement"))
	bool bClampPanMovement;
	UPROPERTY(EditAnywhere, BlueprintReadOnly, Category="IdealTwinCharacter|Pan Movement",
		meta = (EditCondition="bClampPanMovement"))
	FVector ClampExtendMovementLimits;
	UPROPERTY(EditAnywhere, Category="IdealTwinCharacter|Pan Movement")
	bool bDebugMovementLimits;

	UPROPERTY(EditAnywhere, BlueprintReadWrite, Category="IdealTwinCharacter|ViewClamp")
	bool bEnableAutoFixedClampAngle;

private:
	FVector MaxClampMov;
	FVector MinClampMov;
};
