// Fill out your copyright notice in the Description page of Project Settings.

#pragma once

#include "CoreMinimal.h"
#include "IdealTwinBaseCharacter.h"
#include "IdealTwinWalkCharacter.generated.h"

/* Character prepared to be use in interiors or first-person tours. This character implements IPawnSwitchInterface
 */
UCLASS()
class IDEALTWINPRO_API AIdealTwinWalkCharacter : public AIdealTwinBaseCharacter
{
	GENERATED_BODY()

public:
	// Sets default values for this character's properties
	AIdealTwinWalkCharacter(const FObjectInitializer& ObjectInitializer);
	

	UFUNCTION(BlueprintCallable)
	void TabTouchMove(FVector2D TouchPosition);
	
	// TOUCH IMPLEMENTATION OVERRIDE
	virtual void TouchTab_Implementation(FVector2D TouchPosition) override;

	
protected:
	FVector RaycastFromTouchPos(const FVector2D TouchPos) const;
	void MoveToProjectedNavigationPoint(const FVector Point) const;
	
};
