﻿#pragma once

#include "CoreMinimal.h"
#include "UObject/Interface.h"
#include "IdealTwinInteractionInterface.generated.h"

UINTERFACE(BlueprintType)
class UIdealTwinInteractionInterface : public UInterface { GENERATED_BODY() };

/** Simple interaction interface implemented with the ITwBasePlayerController and UnitVolumeScene classes. They have one
	implementation for the primary and secondary interaction.

	SetFocusActor() is optional to be able to do functionality like highlight or other visual effects.
 */
class IDEALTWINPRO_API IIdealTwinInteractionInterface
{
	GENERATED_BODY()

public:

	/* Trigger primary interaction */
	UFUNCTION(BlueprintCallable, BlueprintNativeEvent ,Category="Interaction")
	bool DoPrimaryInteraction();
	/* Trigger secondary interaction */
	UFUNCTION(BlueprintCallable, BlueprintNativeEvent ,Category="Interaction")
	bool DoSecondaryInteraction();

	/* Communicate to the actor if is focused or not to do visual effects. e.g. useful when actor is hover*/
	UFUNCTION(BlueprintCallable, BlueprintNativeEvent ,Category="Interaction")
	void SetFocusActor(bool bFocus);
	
};
