﻿// Fill out your copyright notice in the Description page of Project Settings.


#pragma once

#include "CoreMinimal.h"
#include "GameFramework/Actor.h"
#include "GameFramework/LevelConfiguration/IdealTwinMapsLinkerConfig.h"
#include "IdealTwinLevelConfiguration.generated.h"

struct FMapLinkerEntry;
class UIdealTwinMapsLinkerConfig;

/** AITwLevelConfigurationw is an actor class to be instantiated inside the level and thus have a configuration with different
	IdealTwin systems such as MapLinker and traveling between levels or also the keycode of the Unitgroup.
	
	Configuration systems:
		- UnitgroupKeycode: Allows you to set which Unitgroup the level belongs to to automate requests to the database.
		- MapLinker: Allows the power to link level between them to make the trips easier and also to be able to
					 have lists to be displayed in the widgets and be able to make choices.
 */
UCLASS(HideCategories=("Rendering","Collision","HLOD","Physics","Input","Networking"), meta=(DisplayName="IdealTwinLevelConfiguration"))
class IDEALTWINPRO_API AIdealTwinLevelConfiguration : public AActor
{
	GENERATED_BODY()

public:
	// Sets default values for this actor's properties
	AIdealTwinLevelConfiguration();

	/*Specific keycode reference of Unit builder. You can find it on idealTwinWeb*/
	UPROPERTY(EditInstanceOnly,BlueprintReadWrite,Category="IdealTwin Level Configuration")
	FString UnitGroupKeycode;
	/* Setting the levels you can travel to from this level*/
	UPROPERTY(EditInstanceOnly,BlueprintReadWrite,Category="IdealTwin Level Configuration| MapLinker")
	TSoftObjectPtr<UIdealTwinMapsLinkerConfig> MapLinkerConfig;

	
	/*	Returns the reference of the level Configuration of the level. If there is none in the world and it is used
		an error message is displayed to be set. */
	UFUNCTION(BlueprintCallable, Category="IdealTwin Level Configuration", meta=(WorldContext="WorldContext"))
	static AIdealTwinLevelConfiguration* GetItwLevelConfiguration(const UObject* WorldContext, bool& bValid);

	// MAP LINKER
	/* Return all MapLinker entries*/
	UFUNCTION(BlueprintCallable, Category="IdealTwin Level Configuration| MapLinker")
	bool GetMapLinkerEntries(TArray<FMapLinkerEntry>& MapLinkerEntries);
	/* Change the map to the level given by a MapLinkerLevel. */
	UFUNCTION(BlueprintCallable, Category="IdealTwin Level Configuration| MapLinker")
	bool SwitchToMapLinkerbyEntry(const FMapLinkerEntry& MapLinkerEntry);
	/* Change the map to the level given by the Id of a map in the MapLinkerConfig*/
	UFUNCTION(BlueprintCallable, Category="IdealTwin Level Configuration| MapLinker")
	bool SwitchToMapLinkerbyId(const FName& MapLinkerId);


	/*void SetUnitgroupSelection();*/
	
protected:
	virtual void BeginPlay() override;
};
