﻿// Fill out your copyright notice in the Description page of Project Settings.

#pragma once

#include "CoreMinimal.h"
#include "GameplayTagContainer.h"
#include "UObject/Object.h"
#include "IdealTwinMapsLinkerConfig.generated.h"


UENUM(BlueprintType)
enum EMapLinkerType
{
	EMLT_Neutral		UMETA(DisplayName="Neutral Map"),
	EMLT_Exterior		UMETA(DisplayName="Exterior Map"),
	EMLT_Interior		UMETA(DisplayName="Interior Map"),
};

USTRUCT(BlueprintType)
struct IDEALTWINPRO_API FMapLinkerEntry
{
	GENERATED_BODY()

	/* Entry Id to be use into code*/ 
	UPROPERTY(EditAnywhere,BlueprintReadWrite) FName Id;
	/* Optional name to be set in order to fix the real name*/ 
	UPROPERTY(EditAnywhere,BlueprintReadWrite) FText DisplayName;
	/* Specifies if it has to be exposed in the list. It is intended as decorative in lists*/
	UPROPERTY(EditAnywhere,BlueprintReadWrite) bool Visible = true;
	
	/* Map type to find a specific order*/ 
	UPROPERTY(EditAnywhere,BlueprintReadWrite,Category="MapsLinkerConfig")
	FGameplayTag MapType;
	
	/* Importance of those on the map for when ordered*/
	UPROPERTY(EditAnywhere,BlueprintReadWrite,Category="MapsLinkerConfig")
	int32 ImportanceOrder = -1;
	/* Soft reference of level. NOTE: Remember include level into package list*/ 
	UPROPERTY(EditAnywhere,BlueprintReadWrite)
	TSoftObjectPtr<UWorld> MapReference;

	FMapLinkerEntry();
};


/**
 	MapLinker is a configuration designed to travel between maps easily by linking one map to another from this configuration file.
	To be used within the scene, it must be used with the AIdealTwinLevelConfiguration class, which must be instantiated at the level to be linked.

	Once we have all this in place, we can select the LevelConfiguration instance and get the list to display it or open a level chosen by an id.

	This asset can be created directly from the asset creation menu of the content browser in IdealTwin Asset category.
 */
UCLASS()
class IDEALTWINPRO_API UIdealTwinMapsLinkerConfig : public UDataAsset
{
	GENERATED_BODY()

public:
	/* Alias to search this configuration*/ 
	UPROPERTY(EditAnywhere,BlueprintReadWrite,Category="MapsLinkerConfig")
	FGameplayTag AliasConfiguration;

	/* List of all map links entries*/ 
	UPROPERTY(EditAnywhere,BlueprintReadWrite,Category="MapsLinkerConfig")
	TArray<FMapLinkerEntry> MapsList;

	/* Returns all map linkers entries*/
	UFUNCTION(BlueprintCallable,Category="MapsLinkerConfig")
	TArray<FMapLinkerEntry> GetAllMapEntryType(FGameplayTagContainer InMapType);

	
	
	/* Returns all map linkers ordered by ImportanceOrder*/
	UFUNCTION(BlueprintCallable,Category="MapsLinkerConfig")
	TArray<FMapLinkerEntry> GetAllMapEntryTypesSorted(FGameplayTagContainer InMapType);
};
