// Fill out your copyright notice in the Description page of Project Settings.

#pragma once

#include "CoreMinimal.h"
#include "GameplayTagContainer.h"
#include "Components/ActorComponent.h"
#include "SwitcherPawnComponent.generated.h"


/*	Component to handle possessions logic using GameplayTags. It's so useful when you want switch between different pawns
	into the scene. This component find and store all Pawns with interface PawnSwitcherInterface and allow possessed it

	Important: Pawns to be used with this component must implement PawnSwitcherInterface
 */
UCLASS(ClassGroup=("IdealTwin"),meta=(DisplayName="Switcher Pawn Controller",BlueprintSpawnableComponent))
class IDEALTWINPRO_API USwitcherPawnComponent : public UActorComponent
{
	GENERATED_BODY()

public:
	USwitcherPawnComponent();

	/* Possess pawn in the world with a specific GameplayTag and if there's already one possessed is Unpossess*/
	UFUNCTION(BlueprintCallable, Category="SwitcherPawnComponent")
	bool PossesPawnWithTag(FGameplayTag PawnTag);

	UFUNCTION(BlueprintCallable, Category="SwitcherPawnComponent")
	bool SwitchWithPreviousPawn();
	
	/* Register a new pawn with tag in PawnList. If PawnTag is not valid or PawnReference is null return false*/
	UFUNCTION(BlueprintCallable, Category="SwitcherPawnComponent")
	bool RegisterPawnWithTag(const FGameplayTag& PawnTag, APawn* PawnReference);
	/* UnRegister a pawn with tag in PawnList. If PawnTag is not valid return false*/
	UFUNCTION(BlueprintCallable, Category="SwitcherPawnComponent")
	bool RemovePawnByTag(const FGameplayTag& PawnTag);

	/* Clear list and search again all pawns with PawnSwitcherInterface*/
	UFUNCTION(BlueprintCallable, Category="SwitcherPawnComponent")
	void RefreshPawnActors();

	/* Return all GameplayTags into PawnList*/
	UFUNCTION(BlueprintPure, Category="SwitcherPawnComponent")
	TArray<FGameplayTag> GetRegisterList() const;
	/* Return all GameplayTags into PawnList using Names*/
	UFUNCTION(BlueprintPure, Category="SwitcherPawnComponent")
	TArray<FName> GetRegisterListNames() const;
protected:

	/* On BeginPlay is call RefreshPawnActors to get all reference into Scene*/
	virtual void BeginPlay() override;
	
private:
	UPROPERTY() TMap<FGameplayTag,APawn*> PawnList;
	FGameplayTag PreviousPawn;
	FGameplayTag CurrentPawnTag;
};
