// Fill out your copyright notice in the Description page of Project Settings.

#pragma once

#include "CoreMinimal.h"
#include "ExtraFeatures/Minimap/MinimapConfigAsset.h"
//#include "IdealTwinProUI/Public/Style/IdealTwinStyleModels.h"
#include "IdealTwinProSettings.generated.h"


class UInputMappingContext;
class UUnitVolumeConfig;
class UMaterialParameterCollection;




/** Configurations for the IdealTwin Pro*/
UCLASS(Config = IdealTwin ,DefaultConfig)
class IDEALTWINPRO_API UIdealTwinProSettings : public UDeveloperSettings
{
	GENERATED_BODY()

public:
	UIdealTwinProSettings(const FObjectInitializer& ObjectInitializer);


	/* If true UIdealTwinInputSubsystem will initialize User Input Activity to detect if the user is AFK*/
	UPROPERTY(Config, EditAnywhere,BlueprintReadWrite, Category="General|InputManager")
	bool bAutoStartUserInputDetection;
	/* Time delay to determinate if the user is AFK in seconds*/
	UPROPERTY(Config, EditAnywhere,BlueprintReadWrite, Category="General|InputManager")
	float SecondsInactivityDetectionTime;
	
	UPROPERTY(Config, EditAnywhere,BlueprintReadWrite, Category="General|Input")
	TSoftObjectPtr<UInputMappingContext> DefaultInteractionInputMapping;
	UPROPERTY(Config, EditAnywhere,BlueprintReadWrite, Category="General|Input")
	TSoftObjectPtr<UInputMappingContext> DefaultMovementInputMapping;
	UPROPERTY(Config, EditAnywhere,BlueprintReadWrite, Category="General|Input")
	TSoftObjectPtr<UInputMappingContext> DefaultTouchInputMapping;
	UPROPERTY(Config, EditAnywhere,BlueprintReadWrite, Category="General|Input")
	TSoftObjectPtr<UInputMappingContext> DefaultDetectionInputMapping;
	
	/// UNIT Volume
	/* Default configuration asset for the visual part of the UnitVolumes*/
	UPROPERTY(Config, EditAnywhere,BlueprintReadWrite, Category="UnitVolume")
	TSoftObjectPtr<UUnitVolumeConfig> UnitVolumeConfig;


	/// SECTION CUTTING
	/* Configuration asset for the Cutting Section and to be able to make different cuts.
	   NOTE: No need to touch. */
	UPROPERTY(Config, EditAnywhere,BlueprintReadWrite, Category="Section Cutting")
	TSoftObjectPtr<UMaterialParameterCollection> SectionCuttingCollection;

	/// Minimap
	UPROPERTY(Config, EditAnywhere,BlueprintReadWrite, Category="Minimap")
	TSoftObjectPtr<UMinimapConfigAsset> MinimapDataAsset;
	
#if WITH_EDITOR
	virtual void PostEditChangeProperty(FPropertyChangedEvent& PropertyChangedEvent) override;
	virtual void PostLoad() override;
#endif
};
