﻿// Fill out your copyright notice in the Description page of Project Settings.

#pragma once

#include "CoreMinimal.h"
#include "EngineUtils.h"
#include "UObject/Object.h"
#include "IdealTwinProUtilities.generated.h"


UCLASS()
class IDEALTWINPRO_API UIdealTwinProUtilities : public UBlueprintFunctionLibrary
{
	GENERATED_BODY()

public:
	UFUNCTION(BlueprintCallable,Category="IdealTwinUtility", meta=(DefaultToSelf,WorldContext="WorldContext",DeterminesOutputType ="ComponentClass", DynamicOutputParam = "OutComponents"))
	static void GetAllComponentOfClass(UObject* WorldContext, TSubclassOf<UActorComponent> ComponentClass, TArray<UActorComponent*>& OutComponents);

	template<typename InClass>
	static TArray<InClass*> GetAllComponentsOfClass(UObject* WorldContext);
};

template <class InClass>
TArray<InClass*> UIdealTwinProUtilities::GetAllComponentsOfClass(UObject* WorldContext)
{
	TArray<InClass*> OutComponents;
	for (TActorIterator<AActor> It(GEngine->GetWorldFromContextObjectChecked(WorldContext)); It; ++It)
	{
		TArray<InClass*> ActorComponents;
		It->GetComponents<InClass>(ActorComponents);
		if(!ActorComponents.IsEmpty())
			OutComponents.Append(ActorComponents);
	}
	return OutComponents;
}
