// Fill out your copyright notice in the Description page of Project Settings.

#pragma once

#include "CoreMinimal.h"
#include "UObject/Object.h"
#include "InputManagment/IdealTwinUIProcessor.h"


#include "IdealTwinInputSubsystem.generated.h"

class FIdealTwinUIProcessor;
class UIdealTwinUIInputManager;
/** */
UCLASS() class IDEALTWINPRO_API UIdealTwinInputSubsystem : public ULocalPlayerSubsystem
{
	GENERATED_BODY()
public:

	static UIdealTwinInputSubsystem* Get(UObject* World);
	
	// Begin ULocalPlayerSubsystem
	virtual void Initialize(FSubsystemCollectionBase& Collection) override;
	virtual void PlayerControllerChanged(APlayerController* NewPlayerController) override;
	virtual void Deinitialize() override;
	// End ULocalPlayerSubsystem


	// USER INPUT ACTIVITY DETECTION
	DECLARE_DYNAMIC_MULTICAST_DELEGATE_OneParam(FOnUserIsActivatedChange,bool,bIsActive);
	UPROPERTY(BlueprintAssignable, Category = "IdealTwinUIInputManager", meta = (AllowPrivateAccess))
	FOnUserIsActivatedChange OnUserIsActivatedChange;
	UFUNCTION(BlueprintCallable,Category="IdealTwinUIInputManager")
	void SetUserInputActivityDetection(bool bActivateDetection);
	UFUNCTION(BlueprintCallable,Category="IdealTwinUIInputManager")
	void SetInactiveDetectionTime(float DetectionsSeconds, bool bResetTimer = false);

	UFUNCTION(BlueprintPure,Category="IdealTwinUIInputManager")
	bool IsUserInactive()const;
protected:
	void SwitchUserActivity(bool bSwitchTo) const;
	// END USER INPUT ACTIVITY DETECTION

	
	friend FIdealTwinUIProcessor;
	TSharedPtr<FIdealTwinUIProcessor> InputProcessor;
private:
	float TimeDetection;
};
