// Fill out your copyright notice in the Description page of Project Settings.

#pragma once

#include "CoreMinimal.h"
#include "Framework/Application/IInputProcessor.h"

class FSlateApplication;
struct FAnalogInputEvent;
struct FKeyEvent;
struct FMotionEvent;
struct FPointerEvent;

class UIdealTwinInputSubsystem;
/**
 * 
 */
class IDEALTWINPRO_API FIdealTwinUIProcessor : public IInputProcessor
{
public:
	explicit FIdealTwinUIProcessor(UIdealTwinInputSubsystem* IntInputManager);

	//~ Begin IInputProcessor interface
	virtual void Tick(const float DeltaTime, FSlateApplication& SlateApp, TSharedRef<ICursor> Cursor) override;
	virtual bool HandleKeyDownEvent(FSlateApplication& SlateApp, const FKeyEvent& InKeyEvent) override;
	virtual bool HandleKeyUpEvent(FSlateApplication& SlateApp, const FKeyEvent& InKeyEvent) override;
	virtual bool HandleAnalogInputEvent(FSlateApplication& SlateApp, const FAnalogInputEvent& InAnalogInputEvent) override;
	virtual bool HandleMouseMoveEvent(FSlateApplication& SlateApp, const FPointerEvent& MouseEvent) override;
	virtual bool HandleMouseButtonDownEvent( FSlateApplication& SlateApp, const FPointerEvent& MouseEvent) override;
	virtual bool HandleMouseButtonUpEvent( FSlateApplication& SlateApp, const FPointerEvent& MouseEvent) override;
	virtual bool HandleMouseButtonDoubleClickEvent(FSlateApplication& SlateApp, const FPointerEvent& MouseEvent) override;
	virtual bool HandleMouseWheelOrGestureEvent(FSlateApplication& SlateApp, const FPointerEvent& InWheelEvent, const FPointerEvent* InGestureEvent) override;
	virtual const TCHAR* GetDebugName() const { return TEXT("IdealTwinUIPreprocessor"); }
	//~ End IInputProcessor interface

	/** Processor will check if the user haven't pressed any input or move the mouse with the time assigned 
	 * @param InTimeDetection Time in seconds to determinate if the user is inactive */
	void StartUserActivityDetection(float InTimeDetection = 300);
	/* Stop the Processor detection and won't notify user inactivity*/
	void StopUserActivityDetection();

	/* Return uf the user was inactive (AFK) for a while. For this make sure the StartUserActivityDetection is active. Otherwise, it will return false*/
	bool IsUserInactive()const;
protected:
	/* Called when the user has pressed some input or move the mouse*/
	void UserInputUsed();
	/* Check if the last time registered as "activate" if less than the TimeDetection*/
	void DetectUserActivity();
	/* Change User activity and notify it to UIdealTwinInputSubsystem*/
	void SetUserActivity(bool bNewActivity);
	
	UIdealTwinInputSubsystem* InputManager;

private:
	bool bUseActivityDetection;
	bool bIsActiveUser;
	float TimeDetection;
	float LastTimeActive;
};
