// Fill out your copyright notice in the Description page of Project Settings.

#pragma once

#include "CoreMinimal.h"
#include "AssetDefinitionDefault.h"
#include "Features/LevelVariant/IdealTwinConfiguratorDataAsset.h"
#include "UObject/Object.h"
#include "ConfiguratorDataAsset_AssetDefinition.generated.h"



UCLASS() class IDEALTWINPROEDITOR_API UConfiguratorItemOverride_AssetDefinition : public UAssetDefinitionDefault
{
	GENERATED_BODY()
protected:
	virtual FText GetAssetDisplayName() const override { return NSLOCTEXT("UConfiguratorItemOverride_AssetDefinition", "AssetTypeActions_ConfiguratorItemOverride", "Configurator Items Override"); }
	virtual FLinearColor GetAssetColor() const override { return FLinearColor(FColor::Emerald); }
	virtual TSoftClassPtr<UObject> GetAssetClass() const override { return UIdealTwinConfiguratorItemOverride::StaticClass(); }
	virtual TConstArrayView<FAssetCategoryPath> GetAssetCategories() const override
	{
		static const auto Categories = { FAssetCategoryPath(
			NSLOCTEXT("UConfiguratorItemOverride_AssetDefinition", "Cat", "IdealTwinAsset"),
			NSLOCTEXT("UConfiguratorItemOverride_AssetDefinition", "SubCat", "Configurator")) };
		return Categories;
	}
};

UCLASS() class IDEALTWINPROEDITOR_API UConfiguratorDataAsset_AssetDefinition : public UAssetDefinitionDefault
{
	GENERATED_BODY()
protected:
	virtual FText GetAssetDisplayName() const override { return NSLOCTEXT("UConfiguratorDataAsset_AssetDefinition", "AssetTypeActions_ConfiguratorDataAsset", "Configurator Data Asset"); }
	virtual FLinearColor GetAssetColor() const override { return FLinearColor(FColor::Purple); }
	virtual TSoftClassPtr<UObject> GetAssetClass() const override { return UIdealTwinConfiguratorDataAsset::StaticClass(); }
	virtual TConstArrayView<FAssetCategoryPath> GetAssetCategories() const override
	{
		static const auto Categories = { FAssetCategoryPath(
			NSLOCTEXT("UConfiguratorDataAsset_AssetDefinition", "Cat", "IdealTwinAsset"),
			NSLOCTEXT("UConfiguratorDataAsset_AssetDefinition", "SubCat", "Configurator")) };
		return Categories;
	}
};
