// Fill out your copyright notice in the Description page of Project Settings.

#pragma once

#include "CoreMinimal.h"
#include "AssetDefinitionDefault.h"
#include "Style/IdealTwinUIStyleConfiguration.h"
#include "UObject/Object.h"
#include "UIStyleConfiguration_AssetDefinition.generated.h"

UCLASS() class IDEALTWINPROEDITOR_API UUIStyleConfiguration_AssetDefinition : public UAssetDefinitionDefault
{
	GENERATED_BODY()
protected:
	virtual FText GetAssetDisplayName() const override { return NSLOCTEXT("UIdealTwinUIConfig_AssetDefinition", "AssetTypeActions_IdealTwinUIConfig", "UI Style Configuration"); }
	virtual FLinearColor GetAssetColor() const override { return FLinearColor(FColor::Emerald); }
	virtual TSoftClassPtr<UObject> GetAssetClass() const override { return UIdealTwinUIStyleConfiguration::StaticClass(); }
	virtual TConstArrayView<FAssetCategoryPath> GetAssetCategories() const override
	{
		static const auto Categories = { FAssetCategoryPath(
			NSLOCTEXT("UIdealTwinUIConfig_AssetDefinition", "Cat", "IdealTwinAsset"),
			NSLOCTEXT("UIdealTwinUIConfig_AssetDefinition", "SubCat", "UI")) };
		return Categories;
	}
};
