﻿#pragma once

#include "CoreMinimal.h"
#include "Style/IdealTwinStyleModels.h"


class FDetailWidgetDecl;
class SSearchableComboBox;

class FIdealTwinColorCustomization : public IPropertyTypeCustomization
{
public:
	static TSharedRef<class IPropertyTypeCustomization> MakeInstance()
	{
		return MakeShareable(new FIdealTwinColorCustomization());
	}
	FIdealTwinColorCustomization(){}


	virtual void CustomizeHeader(TSharedRef<IPropertyHandle> PropertyHandle, FDetailWidgetRow& HeaderRow,
	                             IPropertyTypeCustomizationUtils& CustomizationUtils) override;
	virtual void CustomizeChildren(TSharedRef<IPropertyHandle> PropertyHandle, IDetailChildrenBuilder& ChildBuilder,
		IPropertyTypeCustomizationUtils& CustomizationUtils) override;
	FSlateBrush* GetBrushBorder();


	TSharedPtr<SWidget> CreatePalettePicker();
	
	FText GetContentComboBox() const;
	
	FName GetColorValue() const;
	void SetColorValue(FString InValue) const;

	FSlateColor GetMainColor() const;
	FSlateColor GetSlateColor() const;

	EColorHandlerMode GetColorMode() const; 
	bool IsContrast()const;
protected:

	TSharedRef<SHorizontalBox> CreateColorBorder(const FName& InStyle);
	
	TArray<TSharedPtr<FString>> GetComboOptions() const;
	TArray<TSharedPtr<FString>> GetComboOptionsSimple() const;
	bool GetColorPalette(FSlateColor& Color, bool bContrastValue) const;
	FSlateColor GetContrastColor() const;

	TSharedRef<SWidget> OnGenerateWidget(TSharedPtr<FString> ItemName);

	static FSlateColor GetColorByID(FName ColorID, bool bContrast);
	
	bool GetContrastValue()const;
	void SetContrastValue(bool bContrastValue)const;

	
	TSharedPtr<IPropertyHandle> ColorModeHandler;
	TSharedPtr<IPropertyHandle> ColorHandler;
	TSharedPtr<IPropertyHandle> ContrastHandler;
	TSharedPtr<IPropertyHandle> ColorCustomHandler;
	TSharedPtr<IPropertyHandle> UseOverrideOpacityHandler;
	TSharedPtr<IPropertyHandle> OverrideOpacityHandler;
	
	TSharedPtr<SWidget> CustomColorWidget;
};
