﻿// Fill out your copyright notice in the Description page of Project Settings.

#pragma once

#include "CoreMinimal.h"
#include "FIdealTwinColorCustomization.h"
#include "Style/IdealTwinStyleModels.h"
#include "Widgets/Views/STileView.h"


class SSearchableComboBox;

class IDEALTWINPROEDITOR_API FIdealTwinFontIconHandlerCustomization : public IPropertyTypeCustomization
{
public:

	struct FIconItemViewEntry
	{
		const FName IconName;
		TArray<FName> StylesValues;
		TArray<FName> SearchValues;

		FIconItemViewEntry(){}
		FIconItemViewEntry(const FName& InIconName,
			TArray< FName> InStylesValues, TArray< FName> InSearchValues)
				:IconName(InIconName),StylesValues(InStylesValues),SearchValues(InSearchValues)
		{}
		bool ContainString(const FString& Compare,const FName& StyleNameCompare)const;
	};
	
	static TSharedRef<IPropertyTypeCustomization> MakeInstance()
	{
		return MakeShareable(new FIdealTwinFontIconHandlerCustomization());
	}
	FIdealTwinFontIconHandlerCustomization()
		:SourceList(nullptr)
	{
	}

	virtual void CustomizeHeader(TSharedRef<IPropertyHandle> PropertyHandle, FDetailWidgetRow& HeaderRow,
	                             IPropertyTypeCustomizationUtils& CustomizationUtils) override;
	virtual void CustomizeChildren(TSharedRef<IPropertyHandle> PropertyHandle, IDetailChildrenBuilder& ChildBuilder,
		IPropertyTypeCustomizationUtils& CustomizationUtils) override;
	

protected:
	// PROPERTY HANDLERS
	TSharedPtr<IPropertyHandle> FontIconNameHandler;
	TSharedPtr<IPropertyHandle> IconStyleHandler;
	TSharedPtr<IPropertyHandle> IconNameHandler;
	TSharedPtr<IPropertyHandle> IconColorHandler;

	// SEARCHBOX OPTIONS
	TArray<TSharedPtr<FString>> FontIconOptions;
	TArray<TSharedPtr<FString>> IconStyleOptions;
	TArray<TSharedPtr<FString>> IconNamesOptions;

	TArray<TSharedPtr<FString>> GetFontIconOptions() const;
	TArray<TSharedPtr<FString>> GetIconStylesOptions() const;
	TArray<TSharedPtr<FString>> GetIconsNamesOptions() const;

	// FONT AND UNICODE
	FText GetUnicodeText(const FName& IconName)const;
	FSlateFontInfo GetFontInfo() const;

	// FILTER VALUES
	TArray<TSharedPtr<FIconItemViewEntry>> FilterListItems(const FText& InText) const;

	void SelectCurrentIconName() const;
	
	// FILL SOURCE
	void FillSource();
	// UPDATE LIST VIEW
	void UpdateFilterListView();

	// CREATE TILE FOR TILE VIEW
	TSharedRef<ITableRow> MakeTileViewWidget(TSharedPtr<FIconItemViewEntry> Item, const TSharedRef<STableViewBase>& OwnerTable) const;

	// SET/GET PROPERTY VALUE
	FName GetValue(TSharedPtr<IPropertyHandle> Prop)const;
	void SetValue(TSharedPtr<IPropertyHandle> Prop, FName Value)const;
	
	TSharedPtr<FFontIconData> GetFontIconData() const;

private:
	const TArray<TSharedPtr<FIconItemViewEntry>>* SourceList;
	TArray<TSharedPtr<FIconItemViewEntry>> FilteredList;

	TSharedPtr<SSearchableComboBox> IconStyleSeachBox;

	TSharedPtr<SSearchBox> IconNameSearchBox;
	TSharedPtr<STileView<TSharedPtr<FIconItemViewEntry>>> TileView;
	
	TSharedPtr<FFontIconData> FontIconData;
	
	TSharedPtr<FIdealTwinColorCustomization> IconColorCustomization;
};


