// Fill out your copyright notice in the Description page of Project Settings.

#pragma once

#include "CoreMinimal.h"
#include "ITwEditorPanelInterface.h"
#include "ITwEWPanelData.h"
#include "ITwEWDevInfo.generated.h"

class UITwButton;
class UITwImage;
class UImage;
class UTextBlock;
/**
 * 
 */
UCLASS()
class IDEALTWINPROEDITOR_API UITwEWDevInfo : public UITwEWPanelData
{
	GENERATED_BODY()

public:
	UPROPERTY(BlueprintReadOnly, meta=(BindWidget))
	TObjectPtr<UTextBlock> DevName;
	UPROPERTY(BlueprintReadOnly, meta=(BindWidget))
	TObjectPtr<UTextBlock> DevEmail;
	UPROPERTY(BlueprintReadOnly, meta=(BindWidget))
	TObjectPtr<UITwImage> DevImage;
	UPROPERTY(BlueprintReadOnly, meta=(BindWidgetOptional))
	TObjectPtr<UITwButton> LogoutButton;


	UFUNCTION(BlueprintCallable,Category="ITwEWDevInfo")
	void SetDevUserInRuntime(bool bUseInRuntime);
	UFUNCTION(BlueprintCallable,Category="ITwEWDevInfo")
	bool GetDevUserInRuntime()const;
	
	virtual void NativeConstruct() override;

	virtual void ActivateDataPanel_Implementation() override;


protected:
	UFUNCTION() void ReceivedClickLogout(FName ButtonID);
};
