// Fill out your copyright notice in the Description page of Project Settings.

#pragma once

#include "CoreMinimal.h"
#include "ITwEWPanelData.h"
#include "UObject/Object.h"
#include "IdealTwinCommon/ProjectRequestsManager/IdealTwinProjectRequestManager.h"
#include "ITwEWListDisplayer.generated.h"


class UITwEditableText;
class UListView;
class UITwButton;
class UComboBoxString;


UENUM(BlueprintType) enum EListDisplayItemType
{
	ELDIT_UnitGroup		UMETA(DisplayName="UnitGroup"),
	ELDIT_Unit			UMETA(DisplayName="Unit"),
	ELDIT_Configurator	UMETA(DisplayName="Configurator"),
};

UCLASS(Blueprintable,BlueprintType)
class IDEALTWINPROEDITOR_API UListDisplayerItemBase : public UObject
{
	GENERATED_BODY()
public:
	UPROPERTY(EditAnywhere,BlueprintReadWrite,Category="ListDisplayerItemBase") int32 UnitID;
	UPROPERTY(EditAnywhere,BlueprintReadWrite,Category="ListDisplayerItemBase") FString Keycode;
	UPROPERTY(EditAnywhere,BlueprintReadWrite,Category="ListDisplayerItemBase") FString DisplayName;
	UPROPERTY(EditAnywhere,BlueprintReadWrite,Category="ListDisplayerItemBase") TEnumAsByte<EListDisplayItemType> ItemBaseType;


	
	static UListDisplayerItemBase* CreateListDisplayerItemBase(int32 InUnitID, const FString& InKeycode, const FString& InDisplayName, TEnumAsByte<EListDisplayItemType> ItemBaseType);
};


UCLASS() class IDEALTWINPROEDITOR_API UITwEWListDisplayer : public UITwEWPanelData
{
	GENERATED_BODY()

public:
	UITwEWListDisplayer(const FObjectInitializer& ObjectInitializer);
	
	
	UPROPERTY(VisibleAnywhere,BlueprintReadOnly,Category="ListDisplayer",meta=(BindWidget))
	TObjectPtr<UITwButton> HomeButton;
	UPROPERTY(VisibleAnywhere,BlueprintReadOnly,Category="ListDisplayer",meta=(BindWidget))
	TObjectPtr<UITwButton> SubSelectionButton;
	UPROPERTY(VisibleAnywhere,BlueprintReadOnly,Category="ListDisplayer",meta=(BindWidget))
	TObjectPtr<UComboBoxString> ModeSelector;
	UPROPERTY(VisibleAnywhere,BlueprintReadOnly,Category="ListDisplayer",meta=(BindWidget))
	TObjectPtr<UITwEditableText> SearchText;
	UPROPERTY(VisibleAnywhere,BlueprintReadOnly,Category="ListDisplayer",meta=(BindWidget))
	TObjectPtr<UListView> ItemList;

	/// NAVBAR BUTTONS 
	UPROPERTY() TArray<UITwButton*> NavButtonList;
	UFUNCTION(BlueprintCallable, Category="ListDisplayer")
	void SetNavBarButtons(TArray<UITwButton*> InNavBarButtons);
	UFUNCTION(BlueprintImplementableEvent, Category="ListDisplayer")
	void OnNavBarButtonChanged(int32 Index);
	UFUNCTION(BlueprintCallable, Category="ListDisplayer")
	void SetNavBarByIndex(int32 InIndex);
	UFUNCTION() void Received_NavBarButtonChange(UITwButton* ButtonChanged, bool bSelected);
	/// NAVBAR BUTTONS 

	
	
	
	UFUNCTION(BlueprintImplementableEvent, Category="ListDisplayer")
	void OnModeSelectionChange(const FString& ModeName);
	UFUNCTION(BlueprintImplementableEvent, Category="ListDisplayer")
	void OnSelectionTypeChange(EListDisplayItemType InSelectionItemType);
	UFUNCTION(BlueprintImplementableEvent, Category="ListDisplayer")
	void OnListCountChange(int32 ListCount);



	UFUNCTION(BlueprintPure,Category="ITwEWListDisplayer")
	bool IsProjectSelected()const;
	UFUNCTION(BlueprintPure,Category="ITwEWListDisplayer")
	bool IsUnitGroupTarget()const;
	UFUNCTION(BlueprintPure,Category="ITwEWListDisplayer")
	FString GetUnitGroupTargetName()const;


	UFUNCTION(BlueprintCallable,Category="ITwEWListDisplayer")
	void DisplayUnitGroups();
	UFUNCTION(BlueprintCallable,Category="ITwEWListDisplayer")
	void DisplayUnitsFromUnitGroupTarget();
	UFUNCTION(BlueprintCallable,Category="ITwEWListDisplayer")
	void DisplayConfiguratorFromUnitGroupTarget();
	
	UFUNCTION(BlueprintCallable,Category="ITwEWListDisplayer")
	void ClearSearchText();
	
	
	
	virtual void ActivateDataPanel_Implementation() override;
protected:
	UIdealTwinProjectRequestManager* GetRequestManager() const;
	
	virtual void NativeConstruct() override;

	void ResetCurrentSelectionLevel();
	
	void SetUnitGroupList();
	void SetUnitList();
	void SetConfiguratorList();
	
	void RefreshListView();
	
	void ReceivedItemClicked(UObject* Item);
	UFUNCTION() void ReceivedModeSelectorChange(FString SelectedItem, ESelectInfo::Type SelectionType);
	UFUNCTION() void ReceivedHomeButtonClicked(FName ButtonID);

	UFUNCTION() void ReceivedSearchTextChange(const FText& Text);
	
	void Received_UpdateRequestData(EUpdateRequestDataType UpdateType, EUpdateRequestType RequestType);

	int32 CurrentSelectionLevel;
private:
	UPROPERTY() TArray<UListDisplayerItemBase*> CurrentElemetsList;
	FDelegateHandle OnUpdatedInformationHandler;
};
