// Fill out your copyright notice in the Description page of Project Settings.

#pragma once

#include "CoreMinimal.h"
#include "EditorUtilityWidget.h"
#include "IdealTwinCommon/HttpPetitionCommons/DataModels/IdealTwinUserDataModel.h"
#include "UObject/Object.h"
#include "ITwEWLoginUser.generated.h"

class UCheckBox;
class UEditableText;
class UITwButton;


DECLARE_DYNAMIC_MULTICAST_DELEGATE_TwoParams(FLoginResult,bool,bSuccess,FLoginInfo,LoginInfo);

UCLASS(Abstract)
class IDEALTWINPROEDITOR_API UITwEWLoginUser : public UEditorUtilityWidget
{
	GENERATED_BODY()
public:
	UITwEWLoginUser(const FObjectInitializer& ObjectInitializer = FObjectInitializer::Get());

	UPROPERTY(BlueprintAssignable)
	FLoginResult OnLoginResult;
	
	UPROPERTY(VisibleAnywhere,BlueprintReadOnly,Category="LoginUser" , meta=(BindWidget))
	TObjectPtr<UEditableText> UserName;
	UPROPERTY(VisibleAnywhere,BlueprintReadOnly,Category="LoginUser" , meta=(BindWidget))
	TObjectPtr<UEditableText> UserPassword;
	UPROPERTY(VisibleAnywhere,BlueprintReadOnly,Category="LoginUser" , meta=(BindWidget))
	TObjectPtr<UITwButton> SummitButton;

	UPROPERTY(VisibleAnywhere,BlueprintReadOnly,Category="LoginUser" , meta=(BindWidgetOptional))
	TObjectPtr<UCheckBox> RememberUserCheckBox;

	UFUNCTION() void ReceivedClickSummit(FName ButtonID);
	UFUNCTION() void Received_LoginResult(bool bSuccessful, FLoginInfo UserLogInfo);


	UFUNCTION(BlueprintImplementableEvent, Category = "LoginUser")
	void OnRememberMeOption(bool InChecked);
	UFUNCTION(BlueprintCallable, Category = "LoginUser")
	void SetRememberMeOption(bool InChecked);

	UFUNCTION(BlueprintCallable,BlueprintImplementableEvent, Category = "LoginUser")
	void OnLoginResultReceived(bool bSuccessful);

	UFUNCTION(BlueprintImplementableEvent,Category="LoginUser")
	void OnLoginInProcess(bool bInProgress);
	
protected:
	virtual void NativeConstruct() override;

	void LoadUserDataSaved();

	bool bRememberMeOption;
};
