// Fill out your copyright notice in the Description page of Project Settings.

#pragma once

#include "CoreMinimal.h"
#include "IdealTwinAPI/RealEstateAPI/Models/IdealTwinRealEstateDataModels.h"
#include "ITwEWPanelData.h"
#include "ITwEWProjectSelector.generated.h"

class UCheckBox;
class UComboBoxString;
class UITwButton;
class UITwEditableText;


/**
 * 
 */
UCLASS()
class IDEALTWINPROEDITOR_API UITwEWProjectSelector : public UITwEWPanelData
{
	GENERATED_BODY()

public:
	UPROPERTY(BlueprintReadOnly, meta=(BindWidget))
	TObjectPtr<UITwEditableText> ProjectKeyCode;
	
	UPROPERTY(BlueprintReadOnly, meta=(BindWidget))
	TObjectPtr<UITwEditableText> ProjectName;
	
	UPROPERTY(BlueprintReadOnly, meta=(BindWidget))
	TObjectPtr<UComboBoxString> ProjectSelection;
	
	UPROPERTY(BlueprintReadOnly, meta=(BindWidgetOptional))
	TObjectPtr<UCheckBox> ForceUpdateCheckBox;
	UPROPERTY(BlueprintReadOnly, meta=(BindWidgetOptional))
	TObjectPtr<UITwButton> SetAsDefault;
	UPROPERTY(BlueprintReadOnly, meta=(BindWidgetOptional))
	TObjectPtr<UITwButton> CopyApyKey;

	virtual void NativeConstruct() override;
	virtual void NativePreConstruct() override;
	virtual void ActivateDataPanel_Implementation() override;
	
	UFUNCTION(BlueprintCallable,Category="ITwEWProjectSelector")
	void SetUpdateInformationOnChange(bool bForce); 
	UFUNCTION(BlueprintImplementableEvent,Category="ITwEWProjectSelector")
	void OnRequestingUserProjectsProcess(bool bInProcess);
	
	UFUNCTION(BlueprintCallable,Category="ITwEWProjectSelector")
	void RequestEditorUserProjects();
	void UpdateSelectedProject() const;
	
	UFUNCTION(BlueprintCallable,Category="ITwEWProjectSelector")
	FProject GetSelectedProject()const {return SelectedProject;}
	
	UFUNCTION(BlueprintCallable,Category="ITwEWProjectSelector")
	
	FProject GetProjectByKeyCode(FName KeyCode);
	FProject GetProjectByName(FName InProjectName);

protected:
	virtual void NativeDestruct() override;
	virtual void NativeOnInitialized() override;
	
	void FillOptions();

	UFUNCTION() void Received_CopyApiKey(FName ButtonID);
	UFUNCTION() void Received_SetAsDefaultApiKey(FName ButtonID);	
	UFUNCTION() void Received_SelectionChanged(FString SelectedItem, ESelectInfo::Type SelectionType);
	UFUNCTION() void Received_ProjectsResponse(bool bSuccess, TArray<FProject> UserProjectList);
	UFUNCTION() void Received_ForceUpdateChange(bool bIsChecked);

	UFUNCTION() UWidget* GenerateComboContentWidget(FName Item);
	UFUNCTION() UWidget* GenerateComboItemWidget(FString Item);

private:
	TArray<FProject> ProjectList;
	FDelegateHandle UserProjectsListHandle;
	FProject SelectedProject;
	bool bForceUpdate;
};
