// Fill out your copyright notice in the Description page of Project Settings.

#pragma once

#include "CoreMinimal.h"
#include "EditorUtilityWidget.h"
#include "UObject/Object.h"
#include "ITwEWMinimapTool.generated.h"

class UMinimapConfigAsset;
class AMinimapLevelController;
/**
 * 
 */
UCLASS()
class IDEALTWINPROEDITOR_API UITwEWMinimapTool : public UEditorUtilityWidget
{
	GENERATED_BODY()
public:
	virtual void NativeOnInitialized() override;
	
	UFUNCTION(BlueprintImplementableEvent, Category = "MinimapTool")
	void OnScanMinimapLevel();
	
	UFUNCTION(BlueprintCallable,Category="MinimapTool")
	void FindMinimapLevelController();
	UFUNCTION(BlueprintPure, Category = "MinimapTool")
	UMinimapConfigAsset* GetMinimapConfig() const;

	UFUNCTION(BlueprintPure, Category = "MinimapTool")
	bool GetMinimapFloorRange(int32& MinFloor, int32& MaxFloor) const;

	UFUNCTION(BlueprintCallable, Category = "MinimapTool")
	bool SetActiveMinimapFloor(int32 FloorIndex);

	UFUNCTION(BlueprintPure, Category = "MinimapTool")
	int32 GetActiveMinimapFloor() const;

	UFUNCTION(BlueprintPure, Category = "MinimapTool")
	bool HasMinimapFloors() const;

	UFUNCTION(BlueprintCallable, Category = "MinimapTool")
	void SetActiveFloorWidgetTransform(const FWidgetTransform& NewTransform);

protected:
	UPROPERTY(BlueprintReadOnly, Category = "MinimapTool")
	TObjectPtr<AMinimapLevelController> MinimapLevelController;
};

