

#pragma once

#include "CoreMinimal.h"
#include "EditorUtilityWidget.h"
#include "Features/UnitVolume/UnitVolumeActor.h"

#include "ITwEWUnitVolumeDuplicationList.generated.h"


UCLASS(BlueprintType)
class IDEALTWINPROEDITOR_API UITwEWUnitVolumeDuplication_Item : public UObject
{
	GENERATED_BODY()

public:
	UPROPERTY(BlueprintReadWrite, EditAnywhere, Category = "Editor|IdealTwin|ITwEWUnitVolumeDuplication_Item")
	FName Identifier;
	UPROPERTY(BlueprintReadWrite, EditAnywhere, Category = "Editor|IdealTwin|ITwEWUnitVolumeDuplication_Item")
	TArray<AUnitVolumeActor*> DuplicateActors;
};

UCLASS()
class IDEALTWINPROEDITOR_API UITwEWUnitVolumeDuplicationList : public UEditorUtilityWidget
{
	GENERATED_BODY()
public:

	UFUNCTION(BlueprintImplementableEvent,Category= "Editor|IdealTwin|ITwEWUnitVolumeDuplicationList")
	void OnDuplicationsList(const TArray<UITwEWUnitVolumeDuplication_Item*>& ItemList);
	UFUNCTION(BlueprintCallable, Category = "Editor|IdealTwin|ITwEWUnitVolumeDuplicationList")
	void CheckForDuplications();

protected:
	TMap<FName, TArray<AUnitVolumeActor*>> UnitVolumeDuplicated;
};
