// Fill out your copyright notice in the Description page of Project Settings.

#pragma once

#include "CoreMinimal.h"
#include "AssetDefinitionDefault.h"
#include "UObject/Object.h"
#include "ActionAssetFactories.generated.h"


/// InteractiveSpotPlacement ACTION
UCLASS() class IDEALTWINPROEDITOR_API UISPActionBaseFactory : public UFactory
{
	GENERATED_BODY()
public:
	UISPActionBaseFactory();

	virtual UObject* FactoryCreateNew(UClass* Class, UObject* InParent, FName Name, EObjectFlags Flags, UObject* Context, FFeedbackContext* Warn) override;
};
UCLASS() class IDEALTWINPROEDITOR_API UISPActionBase_AssetDefinition : public UAssetDefinitionDefault
{
	GENERATED_BODY()
protected:
	virtual FText GetAssetDisplayName() const override;
	virtual FLinearColor GetAssetColor() const override;
	virtual TSoftClassPtr<UObject> GetAssetClass() const override; 
	virtual TConstArrayView<FAssetCategoryPath> GetAssetCategories() const override;
};


///UnitVolume ACTION 
UCLASS() class IDEALTWINPROEDITOR_API UUnitVolumeActionFactory : public UFactory
{
	GENERATED_BODY()
public:
	UUnitVolumeActionFactory();
	virtual UObject* FactoryCreateNew(UClass* Class, UObject* InParent, FName Name, EObjectFlags Flags, UObject* Context, FFeedbackContext* Warn) override;
};
UCLASS() class IDEALTWINPROEDITOR_API UUnitVolumeAction_AssetDefinition : public UAssetDefinitionDefault
{
	GENERATED_BODY()
protected:
	virtual FText GetAssetDisplayName() const override;
	virtual FLinearColor GetAssetColor() const override;
	virtual TSoftClassPtr<UObject> GetAssetClass() const override; 
	virtual TConstArrayView<FAssetCategoryPath> GetAssetCategories() const override;
};





/**
 * 
 */
UCLASS()
class IDEALTWINPROEDITOR_API UActionAssetFactories : public UObject
{
	GENERATED_BODY()
};


