// Fill out your copyright notice in the Description page of Project Settings.

#pragma once

#include "CoreMinimal.h"
#include "Features/LevelVariant/IdealTwinConfiguratorDataAsset.h"
#include "UObject/Object.h"
#include "ConfiguratorDataAssetFactory.generated.h"

UCLASS() class IDEALTWINPROEDITOR_API UConfiguratorItemOverrideFactory : public UFactory
{
	GENERATED_BODY()
public:
	UConfiguratorItemOverrideFactory()
	{
		bCreateNew = true;
		bEditAfterNew = true;
		SupportedClass = UIdealTwinConfiguratorItemOverride::StaticClass();
	}
	virtual UObject* FactoryCreateNew(UClass* Class, UObject* InParent, FName Name, EObjectFlags Flags, UObject* Context, FFeedbackContext* Warn) override;
};

UCLASS() class IDEALTWINPROEDITOR_API UConfiguratorDataAssetFactory : public UFactory
{
	GENERATED_BODY()
public:
	UConfiguratorDataAssetFactory()
	{
		bCreateNew = true;
		bEditAfterNew = true;
		SupportedClass = UIdealTwinConfiguratorDataAsset::StaticClass();
	}
	virtual UObject* FactoryCreateNew(UClass* Class, UObject* InParent, FName Name, EObjectFlags Flags, UObject* Context, FFeedbackContext* Warn) override;
};
