#pragma once


#include "Modules/ModuleManager.h"

class FAssetTypeActions_Base;
DECLARE_LOG_CATEGORY_EXTERN(LogIdealTwinProEditor, All, All);

DECLARE_DELEGATE_OneParam(FOnIdealTwinMenuCreation, FMenuBuilder&);

class FIdealTwinProEditor : public IModuleInterface
{
	public:
	virtual void StartupModule() override;
	virtual void ShutdownModule() override;
	
	FName IdealTwinSettingsHook;
	FName IdealTwinDeveloperUserHook;
	
	void RegisterDropdownButton();
	TSharedRef<SWidget> MakeIdealTwinMenuWidget();
	TSharedRef<SWidget> GeneratedDeveloperDisplayNameWidget() const;
	
	//Add new MenuBuilder Sections
	void AddCreationMenuDelegate(const FOnIdealTwinMenuCreation& CreationDelegate);

	void RegisterCustomAssets();
	void RegisterIdealTwinCategories();
	void RegisterIdealTwinPlaceableActors();
	void RegisterPropertyTypes();

	// OPEN SETTINGS
	void OpenSDKSettings();
	void OpenProSettings();
	void OpenProUISettings();
	static FReply OpenITwDeveloperPanel();
	static void OpenConverterPanel();


	static void CheckForUnitCollisionDefinition();
private:
	// Array of delegates to extend the menu
	TArray<FOnIdealTwinMenuCreation> MenuCreationDelegate;
	TSharedPtr<FUICommandList> SDKEditorCommands;
	
	TArray<TSharedPtr<FAssetTypeActions_Base>> CustomAssetsRegistration;
	TSharedPtr<FUICommandList> IdealTwinProCommandList;
};