// Fill out your copyright notice in the Description page of Project Settings.

#pragma once

#include "CoreMinimal.h"
#include "UObject/Interface.h"
#include "ITwPanelInterface.generated.h"

UINTERFACE()
class UITwPanelInterface : public UInterface
{
	GENERATED_BODY()
};

/** Interface to handle the panels logic to be able to apply different extra logic on activation/deactivation and more.
 */
class IDEALTWINPROUI_API IITwPanelInterface
{
	GENERATED_BODY()

public:
	UFUNCTION(BlueprintCallable, BlueprintNativeEvent,Category="PanelInterface")
	void RefreshPanel();
	UFUNCTION(BlueprintCallable, BlueprintNativeEvent,Category="PanelInterface")
	void ActivatePanel();
	virtual void ActivatePanel_Implementation();
	UFUNCTION(BlueprintCallable, BlueprintNativeEvent,Category="PanelInterface")
	void DeactivatePanel();
protected:
	bool bIsActivated = false;
};
