﻿// Fill out your copyright notice in the Description page of Project Settings.

#pragma once

#include "CoreMinimal.h"
#include "Engine/DeveloperSettings.h"
#include "IdealTwinProUISettings.generated.h"


class UIdealTwinUIStyleConfiguration;

UCLASS(Config = IdealTwin ,DefaultConfig, DisplayName="IdealTwin Pro UI Settings")
class IDEALTWINPROUI_API UIdealTwinProUISettings : public UDeveloperSettings
{
	GENERATED_BODY()
public:
	UIdealTwinProUISettings(const FObjectInitializer& ObjectInitializer);

	
	UPROPERTY(Config, EditAnywhere,BlueprintReadWrite, Category="IdealTwinStyling")
	TSoftObjectPtr<UIdealTwinUIStyleConfiguration> ProjectUIConfiguration;

	
#if WITH_EDITOR
virtual void PostEditChangeChainProperty(FPropertyChangedChainEvent& PropertyChangedEvent) override;
#endif
};
