﻿// Fill out your copyright notice in the Description page of Project Settings.

#pragma once

#include "CoreMinimal.h"
#include "Style/IdealTwinStyleModels.h"
#include "Subsystems/EngineSubsystem.h"
#include "IdealTwinUISubsystem.generated.h"

class UWidget;
class UIdealTwinUIStyleConfiguration;
struct FIdealTwinColorSchema;


UCLASS()
class IDEALTWINPROUI_API UIdealTwinUISubsystem : public UEngineSubsystem
{
	GENERATED_BODY()
public:

	/** Implement this for initialization of instances of the system */
	virtual void Initialize(FSubsystemCollectionBase& Collection) override;
	/** Implement this for deinitialization of instances of the system */
	virtual void Deinitialize() override;
	
	static UIdealTwinUISubsystem& Get() { return *GEngine->GetEngineSubsystem<UIdealTwinUISubsystem>(); }
	
	UFUNCTION(BlueprintCallable, Category="IdealTwinUISubsystem")
	void RefreshSettingsReferences();
	UFUNCTION(BlueprintCallable, Category="IdealTwinUISubsystem")
	FLinearColor GetIdealTwinColorByID(FName ColorID, bool bContrast = false)const;
	UFUNCTION(BlueprintCallable, Category="IdealTwinUISubsystem")
	FFontIconData& GetFontIconDataByID(FName FontIconID)const;
	UFUNCTION(BlueprintCallable, Category="IdealTwinUISubsystem")
	FIdealTwinFontStyle GetIdealTwinFontStyle() const;


	TArray<FName> GetAllColorStyleOptions() const;
	TArray<FName> GetAllColorSimpleOptions() const;

	
	TArray<FName> GetAllFontIconOptions()const;
	TArray<FName> GetAllFontIconsStylesNames(const FName& FontIconID) const;
	TArray<FName> GetAllIconsNames(const FName& FontIconID) const;

	UFUNCTION(BlueprintCallable, Category="IdealTwinUISubsystem|Utilities")
	static void ShowsWidget(UWidget* Widget, bool bHitTest);
	UFUNCTION(BlueprintCallable, Category="IdealTwinUISubsystem|Utilities")
	static void CollapseWidget(UWidget* Widget);
	UFUNCTION(BlueprintCallable, Category="IdealTwinUISubsystem|Utilities")
	static void HiddeWidget(UWidget* Widget);	
private:
	UPROPERTY()
	UIdealTwinUIStyleConfiguration* UIConfig;
};
