﻿// Fill out your copyright notice in the Description page of Project Settings.

#pragma once

#include "CoreMinimal.h"
#include "IdealTwinStyleModels.h"
#include "Engine/DataAsset.h"
#include "IdealTwinUIStyleConfiguration.generated.h"

USTRUCT(BlueprintType) struct IDEALTWINPROUI_API FColorKeyValues
{
	GENERATED_BODY()
	UPROPERTY(EditAnywhere,BlueprintReadWrite, Category="ColorKeyValues")
	FLinearColor RegularColor;
	UPROPERTY(EditAnywhere,BlueprintReadWrite, Category="ColorKeyValues")
	FLinearColor ContrastColor;

	FColorKeyValues()
		:RegularColor(FLinearColor::White), ContrastColor(FLinearColor::Gray)
	{}
	FColorKeyValues(const FLinearColor& InRegularColor, const FLinearColor& InContrastColor)
		:RegularColor(InRegularColor), ContrastColor(InContrastColor)
	{}
};

UCLASS(BlueprintType)
class IDEALTWINPROUI_API UIdealTwinUIStyleConfiguration : public UDataAsset
{
	GENERATED_BODY()
public:

	UIdealTwinUIStyleConfiguration(const FObjectInitializer& ObjectInitializer);
	
	UPROPERTY(EditAnywhere,BlueprintReadWrite, Category="IdealTwinUIConfig")
	TMap<FName, FColorKeyValues> ColorStyleMap;
	UPROPERTY(EditAnywhere,BlueprintReadWrite, Category="IdealTwinUIConfig")
	TMap<FName, FLinearColor> ColorSimpleMap;

	
	UPROPERTY(EditAnywhere,BlueprintReadWrite, Category="IdealTwinUIConfig")
	FIdealTwinFontStyle FontStyle;
	UPROPERTY(EditAnywhere,BlueprintReadWrite, Category="IdealTwinUIConfig")
	TMap<FName, FFontIconData> FontIconMap;
	
};
