// Fill out your copyright notice in the Description page of Project Settings.

#pragma once

#include "CoreMinimal.h"
#include "Blueprint/UserWidget.h"
#include "Features/LevelVariant/IdealTwinVariantHandler.h"
#include "UObject/Object.h"
#include "ITwConfiguratorResume.generated.h"

USTRUCT(BlueprintType) struct FConfiguratorFilterValues
{
	GENERATED_BODY()
	UPROPERTY(BlueprintReadWrite,Category="ConfiguratorFilterValues") FName SubCat;
	UPROPERTY(BlueprintReadWrite,Category="ConfiguratorFilterValues") TArray<FIdealTwinConfigProduct> Product;
};


UCLASS(Abstract)
class IDEALTWINPROUI_API UITwConfiguratorResume : public UUserWidget
{
	GENERATED_BODY()
public:

	UFUNCTION(BlueprintImplementableEvent, BlueprintCallable,Category="ConfiguratorResume")
	void OnConfiguratorChangesListUpdate(const TMap<FName, FIdealTwinConfigProduct>& ChangeList);
	

	UFUNCTION(BlueprintCallable,Category="ConfiguratorResume")
	TMap<FName,FConfiguratorFilterValues> FilterCatValues(const TMap<FName, FIdealTwinConfigProduct>& ChangeList);
	
	UFUNCTION(BlueprintPure,Category="ConfiguratorResume")
	void GetKeySplit(const FName& InKey, FName& OutCat, FName& OutSubCat);
	
protected:
	virtual void NativeOnInitialized() override;

	UFUNCTION()void Received_ConfigurationListChanged();

	UPROPERTY() UIdealTwinVariantHandler* VariantHandler;
};
