// Fill out your copyright notice in the Description page of Project Settings.

#pragma once

#include "CoreMinimal.h"
#include "Blueprint/UserWidget.h"
#include "IdealTwinCommon/ProjectRequestsManager/IdealTwinProjectRequestManager.h"
#include "UObject/Object.h"
#include "ITwConfiguratorTargetUnit.generated.h"

/** Widget para hacer el display de la UnitTarget que este selecionada para ser usada en el Configurator 
 */
UCLASS()
class IDEALTWINPROUI_API UITwConfiguratorTargetUnit : public UUserWidget
{
	GENERATED_BODY()

public:
	UFUNCTION(BlueprintImplementableEvent,Category="ConfiguratorTargetUnit")
	void OnConfiguratorUnitTarget(const FUnitData& UnitTargetData);


	
protected:
	void GetConfigTarget();

	
	UFUNCTION() void Received_ManagerDataUpdated(EUpdateRequestDataType DataType, EUpdateRequestType UpdateRequestType);
	virtual void NativeOnInitialized() override;
};
