// Fill out your copyright notice in the Description page of Project Settings.

#pragma once

#include "CoreMinimal.h"
#include "Blueprint/UserWidget.h"
#include "IdealTwinAPI/RealEstateAPI/Models/IdealTwinRealEstateDataModels.h"
#include "UObject/Object.h"
#include "ITwConfiguratorTargetUnitList.generated.h"

/** Widget para seleccionar la Unit que el usuario va a usar a la hora de hacer las configuraciones. Una vez sea elegida
	la Unit será seteada como UnitTarget en el configurador seleccionado.
 */
UCLASS()
class IDEALTWINPROUI_API UITwConfiguratorTargetUnitList : public UUserWidget
{
	GENERATED_BODY()

	public:

	UFUNCTION(BlueprintCallable, Category = "ITwConfiguratorTargetUnitList")
	TArray<FUnitData> GetAvailableUserUnits()const;
};
