// Fill out your copyright notice in the Description page of Project Settings.

#pragma once

#include "CoreMinimal.h"
#include "Blueprint/UserWidget.h"
#include "Features/UnitVolume/UnitsFilterManager.h"
#include "UObject/Object.h"
#include "ITwExteriorUnitList.generated.h"

struct FUnitData;
class UEditableText;
class UListView;
class AUnitVolumeActor;

UCLASS(BlueprintType) class UITwExteriorUnitListObject : public UObject
{
	GENERATED_BODY()
public:
	UPROPERTY(EditAnywhere, BlueprintReadWrite, Category = "ITwExteriorUnitListObject")
	TObjectPtr<AUnitVolumeActor> UnitVolumeActorRef;
};



/* Widget to display a list of units in the level. It's also integrated with UnitVolumeManager to use as selection. */
UCLASS(Abstract)
class IDEALTWINPROUI_API UITwExteriorUnitList : public UUserWidget
{
	GENERATED_BODY()
public:
	UPROPERTY(VisibleAnywhere, BlueprintReadOnly, Category = "ITwExteriorUnitList",meta=(BindWidgetOptional))
	TObjectPtr<UEditableText> SearchBox;
	UPROPERTY(VisibleAnywhere, BlueprintReadOnly, Category = "ITwExteriorUnitList",meta=(BindWidget))
	TObjectPtr<UListView> ListViewContainer;

	UFUNCTION(BlueprintNativeEvent, Category = "ITwExteriorUnitList")
	bool OnElementSorted(const FUnitData& UnitData1, const FUnitData& UnitData2);
	
	UFUNCTION(BlueprintNativeEvent, Category = "ITwExteriorUnitList")
	bool OnElementFilter(const FText& InSearchText, const FUnitData& UnitData);

	UFUNCTION(BlueprintImplementableEvent, Category = "ITwExteriorUnitList")
	void OnRefreshListViewNum();
	UFUNCTION(BlueprintCallable, Category = "ITwExteriorUnitList")
	void FilterUnitList(const FText& InSearchText);

	UFUNCTION(BlueprintCallable, Category = "ITwExteriorUnitList")
	void ReverseUnitList();
	UFUNCTION(BlueprintCallable, Category = "ITwExteriorUnitList")
	void SortUnitList();
	
	UFUNCTION(BlueprintCallable, Category = "ITwExteriorUnitList")
	void ClearSearchFilter();
	
	virtual FReply NativeOnMouseWheel(const FGeometry& InGeometry, const FPointerEvent& InMouseEvent) override;
protected:
	void FillListItems();

	virtual void NativeConstruct() override;
	virtual void NativeOnInitialized() override;

	void ReceivedItemSelectedChange(UObject* Item);
	UFUNCTION() void Received_FilterResult(const FUnitsFilterResult& FilterResult);

	UFUNCTION() void ReceivedSearchBoxChange(const FText& Text);
	UFUNCTION() void ReceivedUnitVolumeUpdateData(const TArray<FUnitData>& InUnitData);
	UFUNCTION() void ReceivedUnitVolumeSelectionClear();
	UFUNCTION() void ReceivedUnitVolumeSelectionChange(const TArray<AUnitVolumeActor*>& UnitVolumes);

private:
	UPROPERTY() TArray<UITwExteriorUnitListObject*> StoredList; 
};
