// Fill out your copyright notice in the Description page of Project Settings.

#pragma once

#include "CoreMinimal.h"
#include "Blueprint/UserWidget.h"
#include "IdealTwinAPI/RealEstateAPI/Models/IdealTwinRealEstateDataModels.h"
#include "UObject/Object.h"
#include "ITwFilterComponent.generated.h"

class UUnitFilter;


DECLARE_DYNAMIC_MULTICAST_DELEGATE(FOnFiltersChanged);
UCLASS(Abstract) class IDEALTWINPROUI_API UITwFilterComponent : public UUserWidget
{
	GENERATED_BODY()
public:

	/* IdealTwinFilterPanelUW will bind this event to knows when need to refresh the filters*/
	UPROPERTY(BlueprintAssignable)
	FOnFiltersChanged OnFiltersChanged;

	/* Call this method when the filter has changed. The value should be set by GetBuildUnitFilter() to build the filter*/
	UFUNCTION(BlueprintCallable,Category="IdealTwinFilterUW")
	void FilterValueHasChange();

	/* When the data is updated return the new list in case this filter need to get values like min and max for slider*/
	UFUNCTION(BlueprintImplementableEvent,Category="IdealTwinFilterUW")
	void OnFilterUnitData(const TArray<FUnitData>& UpdateData);
	/* This is called when the filter should be reset*/
	UFUNCTION(BlueprintImplementableEvent,Category="IdealTwinFilterUW")
	void OnFilterReset();

	/* Return a Unit filter to be applied into the Filter Manager*/
	UFUNCTION(BlueprintImplementableEvent, Category = "IdealTwinFilterUW")
	UUnitFilter* GetBuildUnitFilter();

protected:
	virtual void NativePreConstruct() override;
	virtual void NativeOnInitialized() override;
	
};
