// Fill out your copyright notice in the Description page of Project Settings.

#pragma once

#include "CoreMinimal.h"
#include "Blueprint/UserWidget.h"
#include "Features/UnitVolume/UnitsFilterManager.h"
#include "UObject/Object.h"
#include "ITwFilterPanel.generated.h"

class UUnitFilterCollection;
class AUnitVolumeActor;
class UUnitFilter;
class UITwFilterComponent;
class AUnitVolumesManager;
/**
 * 
 */
UCLASS(Abstract) class IDEALTWINPROUI_API UITwFilterPanel : public UUserWidget
{
	GENERATED_BODY()
public:
	UITwFilterPanel(const FObjectInitializer& ObjectInitializer);
	
	UPROPERTY(EditAnywhere, BlueprintReadWrite, Category = "IdealTwinFilterPanelUW");
	bool bScanForFilters;


	UFUNCTION(Blueprintable,Category = "IdealTwinFiltersPanelUW")
	void SetReactivityFilters(bool bReactive);
	
	/**
	 * Resets all associated filter components of the filter panel.
	 *
	 * This method iterates through all filter widgets stored in the FiltersWidgets array
	 * and invokes the OnFilterReset event for each filter component, ensuring they
	 * revert to their default state.
	 *
	 * Typically used to clear or reset all applied filters in the panel.
	 */
	UFUNCTION(BlueprintCallable, Category = "IdealTwinFiltersPanelUW")
	void ResetFilters();


	
	UFUNCTION(BlueprintCallable, Category = "IdealTwinFiltersPanelUW")
	void SetFiltersWidgets(TArray<UITwFilterComponent*> InFiltersWidgets);
	
	UFUNCTION(BlueprintCallable, Category = "IdealTwinFiltersPanelUW")
	void SetUnitData(const TArray<FUnitData>& InUnitData, bool bRefreshPanel = true);

	UFUNCTION(BlueprintCallable, Category = "IdealTwinFiltersPanelUW")
	TArray<UUnitFilter*> GatherUnitFilters();
	UFUNCTION(BlueprintCallable, Category = "IdealTwinFiltersPanelUW")
	TArray<AUnitVolumeActor*> GetUnitVolumeActorsFromFilters();

	UFUNCTION(BlueprintCallable, Category = "IdealTwinFiltersPanelUW")
	void CommitFilters(TArray<UUnitFilter*> InFilters);
	
	UFUNCTION(BlueprintImplementableEvent,Category = "IDealTwinFiltersPanel")
	void OnUnitDataUpdated();
	UFUNCTION(BlueprintImplementableEvent,Category = "IDealTwinFiltersPanel")
	void OnFilterDataUpdated(int32 SelectionNum,int32 TotalNum);


protected:
	virtual void NativeConstruct() override;
	virtual void NativeOnInitialized() override;
	
	UFUNCTION() void Received_OnFilterResult(const FUnitsFilterResult& FilterResult);
	UFUNCTION() void Received_OnClearAllFilters();
	void FindUVManagerFromScene();

	void RefreshPanel();
	void ScanForFilters();
	
	
	UFUNCTION() void Received_OnFilterChange();
	UFUNCTION() void Received_OnUnitManagerData(const TArray<FUnitData>& InUnitData);
private:
	UPROPERTY() TArray<UITwFilterComponent*> FiltersWidgets;
	UPROPERTY() TObjectPtr<AUnitVolumesManager> UnitVolumesManager;
	UPROPERTY() TArray<FUnitData> UnitDataList;

	UPROPERTY() UUnitsFilterManager* FilterManager;
	UPROPERTY()	TObjectPtr<UUnitFilterCollection> FilterCollection;

};
