﻿// Fill out your copyright notice in the Description page of Project Settings.

#pragma once

#include "CoreMinimal.h"
#include "Blueprint/UserWidget.h"
#include "UObject/Object.h"
#include "IdealTwinButtonGroupSelectionUW.generated.h"

class UIdealTwinButtonUW;


UCLASS(Abstract) class IDEALTWINPROUI_API UIdealTwinButtonGroupSelectionUW : public UUserWidget
{
	GENERATED_BODY()

public:
	UIdealTwinButtonGroupSelectionUW(const FObjectInitializer& ObjectInitializer);
	



	UPROPERTY(EditDefaultsOnly, BlueprintReadOnly, Category="IdealTwinButtonGroupSelectionUW",meta=(BindWidget))
	TObjectPtr<UPanelWidget> ButtonsContainer;
	UPROPERTY(VisibleAnywhere, BlueprintReadOnly, Category="IdealTwinButtonGroupSelectionUW")
	TArray<TObjectPtr<UIdealTwinButtonUW>> ButtonList;
	
	DECLARE_DYNAMIC_MULTICAST_DELEGATE(FOnClearSelection);
	UPROPERTY(BlueprintAssignable,Category="IdealTwinButtonGroupSelectionUW")
	FOnClearSelection OnClearSelection;
	DECLARE_DYNAMIC_MULTICAST_DELEGATE_TwoParams(FOnSelectionChange,int32, SelectionIndex ,const FName&, ButtonSelected);
	UPROPERTY(BlueprintAssignable,Category="IdealTwinButtonGroupSelectionUW")
	FOnSelectionChange OnSelectionChange;

	UFUNCTION(BlueprintPure, Category="IdealTwinButtonGroupSelectionUW")
	bool HasSelection()const;
	UFUNCTION(BlueprintPure, Category="IdealTwinButtonGroupSelectionUW")
	FName GetSelectedButtonID()const;
	UFUNCTION(BlueprintPure, Category="IdealTwinButtonGroupSelectionUW")
	int32 GetSelectedButtonIndex()const;

	
	UFUNCTION(BlueprintCallable, Category="IdealTwinButtonGroupSelectionUW")
	void SetSelectionByButtonID(FName ButtonID);
	UFUNCTION(BlueprintCallable, Category="IdealTwinButtonGroupSelectionUW")
	void SetSelectionByIndex(int32 ButtonIndex);
	UFUNCTION(BlueprintCallable, Category="IdealTwinButtonGroupSelectionUW")
	void SetSelectionByButton(UIdealTwinButtonUW* ButtonReference);

	UFUNCTION(BlueprintCallable, Category="IdealTwinButtonGroupSelectionUW")
	void ClearAllButtonSelection();

	
	UFUNCTION(BlueprintCallable, Category="IdealTwinButtonGroupSelectionUW")
	void RefreshButtonReferences(TArray<UIdealTwinButtonUW*> InButtonList);

protected:
	virtual void BindButtonActions();

	virtual void ScanForChildren();
	
	virtual void NativeOnInitialized() override;
	virtual void NativePreConstruct() override;
	virtual void NativeConstruct() override;

	UFUNCTION() void Received_ButtonSelectionChanged(UIdealTwinButtonUW* ButtonChangeSelection);

private:
	UPROPERTY() TObjectPtr<UIdealTwinButtonUW> CurrentSelection;
};
