﻿// Fill out your copyright notice in the Description page of Project Settings.

#pragma once

#include "CoreMinimal.h"
#include "Blueprint/UserWidget.h"
#include "Widgets/ITwButton.h"
#include "IdealTwinButtonUW.generated.h"


class UITwButton;
class UButton;
DECLARE_DYNAMIC_MULTICAST_DELEGATE_OneParam(FOnButtonSelectionChanged,UIdealTwinButtonUW*, ButtonReference);

UCLASS(Abstract) class IDEALTWINPROUI_API UIdealTwinButtonUW : public UUserWidget
{
	GENERATED_BODY()

public:
	UPROPERTY(BlueprintReadOnly, Category="IdealTwinButtonUW",meta=(BindWidget))
	TObjectPtr<UITwButton> SelectableButton;


	UPROPERTY(VisibleDefaultsOnly,BlueprintReadOnly, Transient,Category="IdealTwinButtonUW",meta=(BindWidgetAnimOptional))
	TObjectPtr<UWidgetAnimation> HoverAnimation;
	UPROPERTY(VisibleDefaultsOnly,BlueprintReadOnly, Transient,Category="IdealTwinButtonUW",meta=(BindWidgetAnimOptional))
	TObjectPtr<UWidgetAnimation> UnHoverAnimation;

	
	// Events
	UPROPERTY(BlueprintAssignable, Category="IdealTwinButtonUW")
	UITwButton::FOnClickWithID OnButtonPressed;
	UPROPERTY(BlueprintAssignable, Category="IdealTwinButtonUW")
	FOnButtonSelectionChanged OnButtonSelectionChange;

	UPROPERTY(EditAnywhere,BlueprintReadWrite, Category="IdealTwinButtonUW",meta=(ExposeOnSpawn))
	FName ButtonID;
	UPROPERTY(EditAnywhere,BlueprintReadWrite, Category="IdealTwinButtonUW",meta=(ExposeOnSpawn))
	bool bStartSelected;
	UPROPERTY(EditAnywhere,BlueprintReadWrite, Category="IdealTwinButtonUW",meta=(ExposeOnSpawn))
	TEnumAsByte<EButtonSelectionMode> ButtonSelectionMode;

	UFUNCTION(BlueprintPure, Category="IdealTwinButtonUW")
	FName GetButtonID() const;
		
	UFUNCTION(BlueprintCallable, Category="IdealTwinButtonUW")
	void SelectButton();
	UFUNCTION(BlueprintCallable, Category="IdealTwinButtonUW")
	void UnSelectButton();
	
	UFUNCTION(BlueprintPure, Category="IdealTwinButtonUW")
	bool IsSelectedButton()const;

	
	UFUNCTION(BlueprintImplementableEvent, Category="IdealTwinButtonUW")
	void OnSelectionButtonChanged(bool Selected);
protected:
	UFUNCTION() void Received_ButtonSelectionChanged(UITwButton* ButtonChanged,bool bSelected);
	
	virtual void NativeOnInitialized() override;
	virtual void NativePreConstruct() override;
	virtual void NativeConstruct() override;
};
