// Fill out your copyright notice in the Description page of Project Settings.

#pragma once

#include "CoreMinimal.h"
#include "Blueprint/UserWidget.h"
#include "Features/InteractSpotPlacement/ITwISPWidgetInterface.h"
#include "ITwISPWidget.generated.h"


class UITwISPPayLoad;
class AITwInteractiveSpot;

UCLASS(DisplayName="ISP Widget", Abstract)
class IDEALTWINPROUI_API UITwISPWidget : public UUserWidget, public IITwISPWidgetInterface
{
	GENERATED_BODY()
	
public:
	virtual void OnISPConstruct_Implementation(AITwInteractiveSpot* InSpot) override;


	UFUNCTION(BlueprintCallable, Category="IdealTwinISPWidget")
	void SelectOwnISPSpot();
	UFUNCTION(BlueprintCallable, Category="IdealTwinISPWidget")
	void UnSelectOwnISPSpot();

	
protected:
	UPROPERTY(VisibleAnywhere, BlueprintReadOnly, Category="IdealTwinISPWidget")
	AITwInteractiveSpot* OwnISPSpot;
	
};
